/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.util.Args;

public class BasicHeaderElement
implements HeaderElement {
    private static final NameValuePair[] EMPTY_NAME_VALUE_PAIR_ARRAY = new NameValuePair[0];
    private final String name;
    private final String value;
    private final NameValuePair[] parameters;

    public BasicHeaderElement(String string, String string2, NameValuePair ... nameValuePairArray) {
        this.name = Args.notNull(string, "Name");
        this.value = string2;
        if (nameValuePairArray != null) {
            this.parameters = nameValuePairArray;
            return;
        }
        this.parameters = EMPTY_NAME_VALUE_PAIR_ARRAY;
    }

    public BasicHeaderElement(String string, String string2) {
        this(string, string2, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public NameValuePair[] getParameters() {
        return (NameValuePair[])this.parameters.clone();
    }

    @Override
    public int getParameterCount() {
        return this.parameters.length;
    }

    @Override
    public NameValuePair getParameter(int n2) {
        return this.parameters[n2];
    }

    @Override
    public NameValuePair getParameterByName(String string) {
        Args.notNull(string, "Name");
        NameValuePair nameValuePair = null;
        NameValuePair[] nameValuePairArray = this.parameters;
        int n2 = this.parameters.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            NameValuePair nameValuePair2 = nameValuePairArray[i2];
            if (!nameValuePair2.getName().equalsIgnoreCase(string)) continue;
            nameValuePair = nameValuePair2;
            break;
        }
        return nameValuePair;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        if (this.value != null) {
            stringBuilder.append("=");
            stringBuilder.append(this.value);
        }
        NameValuePair[] nameValuePairArray = this.parameters;
        int n2 = this.parameters.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            NameValuePair nameValuePair = nameValuePairArray[i2];
            stringBuilder.append("; ");
            stringBuilder.append(nameValuePair);
        }
        return stringBuilder.toString();
    }
}

