/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.util.Args;

public class BasicHeaderIterator
implements Iterator<Header> {
    private final Header[] allHeaders;
    private int currentIndex;
    private final String headerName;

    public BasicHeaderIterator(Header[] headerArray, String string) {
        this.allHeaders = Args.notNull(headerArray, "Header array");
        this.headerName = string;
        this.currentIndex = this.findNext(-1);
    }

    private int findNext(int n2) {
        if (n2 < -1) {
            return -1;
        }
        int n3 = this.allHeaders.length - 1;
        boolean bl2 = false;
        while (!bl2 && n2 < n3) {
            bl2 = this.filterHeader(++n2);
        }
        if (bl2) {
            return n2;
        }
        return -1;
    }

    private boolean filterHeader(int n2) {
        return this.headerName == null || this.headerName.equalsIgnoreCase(this.allHeaders[n2].getName());
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex >= 0;
    }

    @Override
    public Header next() throws NoSuchElementException {
        int n2 = this.currentIndex;
        if (n2 < 0) {
            throw new NoSuchElementException("Iteration already finished.");
        }
        this.currentIndex = this.findNext(n2);
        return this.allHeaders[n2];
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Removing headers is not supported.");
    }
}

