/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.HeaderValueFormatter;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicHeaderValueFormatter
implements HeaderValueFormatter {
    public static final BasicHeaderValueFormatter INSTANCE = new BasicHeaderValueFormatter();
    private static final String SEPARATORS = " ;,:@()<>\\\"/[]?={}\t";
    private static final String UNSAFE_CHARS = "\"\\";

    @Override
    public void formatElements(CharArrayBuffer charArrayBuffer, HeaderElement[] headerElementArray, boolean bl2) {
        Args.notNull(charArrayBuffer, "Char array buffer");
        Args.notNull(headerElementArray, "Header element array");
        for (int i2 = 0; i2 < headerElementArray.length; ++i2) {
            if (i2 > 0) {
                charArrayBuffer.append(", ");
            }
            this.formatHeaderElement(charArrayBuffer, headerElementArray[i2], bl2);
        }
    }

    @Override
    public void formatHeaderElement(CharArrayBuffer charArrayBuffer, HeaderElement headerElement, boolean bl2) {
        int n2;
        Args.notNull(charArrayBuffer, "Char array buffer");
        Args.notNull(headerElement, "Header element");
        charArrayBuffer.append(headerElement.getName());
        String string = headerElement.getValue();
        if (string != null) {
            charArrayBuffer.append('=');
            this.formatValue(charArrayBuffer, string, bl2);
        }
        if ((n2 = headerElement.getParameterCount()) > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                charArrayBuffer.append("; ");
                this.formatNameValuePair(charArrayBuffer, headerElement.getParameter(i2), bl2);
            }
        }
    }

    @Override
    public void formatParameters(CharArrayBuffer charArrayBuffer, NameValuePair[] nameValuePairArray, boolean bl2) {
        Args.notNull(charArrayBuffer, "Char array buffer");
        Args.notNull(nameValuePairArray, "Header parameter array");
        for (int i2 = 0; i2 < nameValuePairArray.length; ++i2) {
            if (i2 > 0) {
                charArrayBuffer.append("; ");
            }
            this.formatNameValuePair(charArrayBuffer, nameValuePairArray[i2], bl2);
        }
    }

    @Override
    public void formatNameValuePair(CharArrayBuffer charArrayBuffer, NameValuePair object, boolean bl2) {
        Args.notNull(charArrayBuffer, "Char array buffer");
        Args.notNull(object, "Name / value pair");
        charArrayBuffer.append(object.getName());
        object = object.getValue();
        if (object != null) {
            charArrayBuffer.append('=');
            this.formatValue(charArrayBuffer, (String)object, bl2);
        }
    }

    void formatValue(CharArrayBuffer charArrayBuffer, String string, boolean bl2) {
        int n2;
        if (!bl2) {
            for (n2 = 0; n2 < string.length() && !bl2; ++n2) {
                bl2 = this.isSeparator(string.charAt(n2));
            }
        }
        if (bl2) {
            charArrayBuffer.append('\"');
        }
        for (n2 = 0; n2 < string.length(); ++n2) {
            char c2 = string.charAt(n2);
            if (this.isUnsafe(c2)) {
                charArrayBuffer.append('\\');
            }
            charArrayBuffer.append(c2);
        }
        if (bl2) {
            charArrayBuffer.append('\"');
        }
    }

    boolean isSeparator(char c2) {
        return SEPARATORS.indexOf(c2) >= 0;
    }

    boolean isUnsafe(char c2) {
        return UNSAFE_CHARS.indexOf(c2) >= 0;
    }
}

