/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.util.ArrayList;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicHeaderElement;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.message.HeaderValueParser;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Tokenizer;
import org.apache.hc.core5.util.Tokenizer$Cursor;
import org.apache.hc.core5.util.Tokenizer$Delimiter;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicHeaderValueParser
implements HeaderValueParser {
    public static final BasicHeaderValueParser INSTANCE = new BasicHeaderValueParser();
    private static final char PARAM_DELIMITER = ';';
    private static final char ELEM_DELIMITER = ',';
    private static final Tokenizer$Delimiter TOKEN_DELIMITER = Tokenizer.delimiters('=', ';', ',');
    private static final Tokenizer$Delimiter VALUE_DELIMITER = Tokenizer.delimiters(';', ',');
    private final Tokenizer tokenizer = Tokenizer.INSTANCE;
    private static final HeaderElement[] EMPTY_HEADER_ELEMENT_ARRAY = new HeaderElement[0];
    private static final NameValuePair[] EMPTY_NAME_VALUE_ARRAY = new NameValuePair[0];

    @Override
    public HeaderElement[] parseElements(CharSequence charSequence, ParserCursor parserCursor) {
        Args.notNull(charSequence, "Char sequence");
        Args.notNull(parserCursor, "Parser cursor");
        ArrayList<HeaderElement> arrayList = new ArrayList<HeaderElement>();
        while (!parserCursor.atEnd()) {
            HeaderElement headerElement = this.parseHeaderElement(charSequence, parserCursor);
            if (headerElement.getName().isEmpty() && headerElement.getValue() == null) continue;
            arrayList.add(headerElement);
        }
        return arrayList.toArray(EMPTY_HEADER_ELEMENT_ARRAY);
    }

    @Override
    public HeaderElement parseHeaderElement(CharSequence charSequence, ParserCursor parserCursor) {
        Args.notNull(charSequence, "Char sequence");
        Args.notNull(parserCursor, "Parser cursor");
        NameValuePair nameValuePair = this.parseNameValuePair(charSequence, parserCursor);
        NameValuePair[] nameValuePairArray = null;
        if (!parserCursor.atEnd()) {
            char c2 = charSequence.charAt(parserCursor.getPos());
            if (c2 == ';' || c2 == ',') {
                ParserCursor parserCursor2 = parserCursor;
                parserCursor2.updatePos(parserCursor2.getPos() + 1);
            }
            if (c2 != ',') {
                nameValuePairArray = this.parseParameters(charSequence, parserCursor);
            }
        }
        return new BasicHeaderElement(nameValuePair.getName(), nameValuePair.getValue(), nameValuePairArray);
    }

    @Override
    public NameValuePair[] parseParameters(CharSequence charSequence, ParserCursor parserCursor) {
        Args.notNull(charSequence, "Char sequence");
        Args.notNull(parserCursor, "Parser cursor");
        this.tokenizer.skipWhiteSpace(charSequence, parserCursor);
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        while (!parserCursor.atEnd()) {
            NameValuePair nameValuePair = this.parseNameValuePair(charSequence, parserCursor);
            arrayList.add(nameValuePair);
            if (parserCursor.atEnd()) continue;
            char c2 = charSequence.charAt(parserCursor.getPos());
            if (c2 == ';') {
                ParserCursor parserCursor2 = parserCursor;
                parserCursor2.updatePos(parserCursor2.getPos() + 1);
            }
            if (c2 != ',') continue;
        }
        return arrayList.toArray(EMPTY_NAME_VALUE_ARRAY);
    }

    @Override
    public NameValuePair parseNameValuePair(CharSequence charSequence, ParserCursor parserCursor) {
        Args.notNull(charSequence, "Char sequence");
        Args.notNull(parserCursor, "Parser cursor");
        String string = this.tokenizer.parseToken(charSequence, (Tokenizer$Cursor)parserCursor, TOKEN_DELIMITER);
        if (parserCursor.atEnd()) {
            return new BasicNameValuePair(string, null);
        }
        char c2 = charSequence.charAt(parserCursor.getPos());
        if (c2 != '=') {
            return new BasicNameValuePair(string, null);
        }
        ParserCursor parserCursor2 = parserCursor;
        parserCursor2.updatePos(parserCursor2.getPos() + 1);
        charSequence = this.tokenizer.parseValue(charSequence, (Tokenizer$Cursor)parserCursor, VALUE_DELIMITER);
        return new BasicNameValuePair(string, (String)charSequence);
    }
}

