/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.util.Locale;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.ReasonPhraseCatalog;
import org.apache.hc.core5.http.impl.EnglishReasonPhraseCatalog;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.HeaderGroup;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;

public class BasicHttpResponse
extends HeaderGroup
implements HttpResponse {
    private static final long serialVersionUID = 1L;
    private final ReasonPhraseCatalog reasonCatalog;
    private ProtocolVersion version;
    private Locale locale;
    private int code;
    private String reasonPhrase;

    public BasicHttpResponse(int n2, ReasonPhraseCatalog reasonPhraseCatalog, Locale locale) {
        this.code = Args.positive(n2, "Status code");
        this.reasonCatalog = reasonPhraseCatalog != null ? reasonPhraseCatalog : EnglishReasonPhraseCatalog.INSTANCE;
        this.locale = locale;
    }

    public BasicHttpResponse(int n2, String string) {
        this.code = Args.positive(n2, "Status code");
        this.reasonPhrase = string;
        this.reasonCatalog = EnglishReasonPhraseCatalog.INSTANCE;
    }

    public BasicHttpResponse(int n2) {
        this.code = Args.positive(n2, "Status code");
        this.reasonPhrase = null;
        this.reasonCatalog = EnglishReasonPhraseCatalog.INSTANCE;
    }

    @Override
    public void addHeader(String string, Object object) {
        Args.notNull(string, "Header name");
        this.addHeader(new BasicHeader(string, object));
    }

    @Override
    public void setHeader(String string, Object object) {
        Args.notNull(string, "Header name");
        this.setHeader(new BasicHeader(string, object));
    }

    @Override
    public void setVersion(ProtocolVersion protocolVersion) {
        this.version = protocolVersion;
    }

    @Override
    public ProtocolVersion getVersion() {
        return this.version;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setCode(int n2) {
        Args.positive(n2, "Status code");
        this.code = n2;
        this.reasonPhrase = null;
    }

    @Override
    public String getReasonPhrase() {
        if (this.reasonPhrase != null) {
            return this.reasonPhrase;
        }
        BasicHttpResponse basicHttpResponse = this;
        return basicHttpResponse.getReason(basicHttpResponse.code);
    }

    @Override
    public void setReasonPhrase(String string) {
        this.reasonPhrase = TextUtils.isBlank(string) ? null : string;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = Args.notNull(locale, "Locale");
    }

    protected String getReason(int n2) {
        if (this.reasonCatalog != null) {
            return this.reasonCatalog.getReason(n2, this.locale != null ? this.locale : Locale.getDefault());
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.code).append(' ').append(this.reasonPhrase).append(' ').append(this.version);
        return stringBuilder.toString();
    }
}

