/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;

class BasicListHeaderIterator
implements Iterator<Header> {
    private final List<? extends Header> allHeaders;
    private int currentIndex;
    private int lastIndex;
    private final String headerName;

    public BasicListHeaderIterator(List<? extends Header> list, String string) {
        this.allHeaders = Args.notNull(list, "Header list");
        this.headerName = string;
        this.currentIndex = this.findNext(-1);
        this.lastIndex = -1;
    }

    protected int findNext(int n2) {
        if (n2 < -1) {
            return -1;
        }
        int n3 = this.allHeaders.size() - 1;
        boolean bl2 = false;
        while (!bl2 && n2 < n3) {
            bl2 = this.filterHeader(++n2);
        }
        if (bl2) {
            return n2;
        }
        return -1;
    }

    private boolean filterHeader(int n2) {
        if (this.headerName == null) {
            return true;
        }
        String string = this.allHeaders.get(n2).getName();
        return this.headerName.equalsIgnoreCase(string);
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex >= 0;
    }

    @Override
    public Header next() throws NoSuchElementException {
        int n2 = this.currentIndex;
        if (n2 < 0) {
            throw new NoSuchElementException("Iteration already finished.");
        }
        this.lastIndex = n2;
        this.currentIndex = this.findNext(n2);
        return this.allHeaders.get(n2);
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        Asserts.check(this.lastIndex >= 0, "No header to remove");
        this.allHeaders.remove(this.lastIndex);
        this.lastIndex = -1;
        --this.currentIndex;
    }
}

