/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.io.Serializable;
import org.apache.hc.core5.http.FormattedHeader;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.hc.core5.util.Tokenizer;

public class BufferedHeader
implements Serializable,
FormattedHeader {
    private static final long serialVersionUID = -2768352615787625448L;
    private final String name;
    private final CharArrayBuffer buffer;
    private final int valuePos;
    private String value;

    public static BufferedHeader create(CharArrayBuffer charArrayBuffer) {
        try {
            return new BufferedHeader(charArrayBuffer);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(parseException.getMessage());
        }
    }

    public BufferedHeader(CharArrayBuffer charArrayBuffer) throws ParseException {
        this(charArrayBuffer, true);
    }

    BufferedHeader(CharArrayBuffer charArrayBuffer, boolean bl2) throws ParseException {
        Args.notNull(charArrayBuffer, "Char array buffer");
        int n2 = charArrayBuffer.indexOf(58);
        if (n2 <= 0) {
            throw new ParseException("Invalid header", charArrayBuffer, 0, charArrayBuffer.length());
        }
        if (bl2 && Tokenizer.isWhitespace(charArrayBuffer.charAt(n2 - 1))) {
            throw new ParseException("Invalid header", charArrayBuffer, 0, charArrayBuffer.length(), n2 - 1);
        }
        String string = charArrayBuffer.substringTrimmed(0, n2);
        if (string.isEmpty()) {
            throw new ParseException("Invalid header", charArrayBuffer, 0, charArrayBuffer.length(), n2);
        }
        this.buffer = charArrayBuffer;
        this.name = string;
        this.valuePos = n2 + 1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            int n2;
            int n3 = this.buffer.length();
            for (n2 = this.valuePos; n2 < this.buffer.length() && Tokenizer.isWhitespace(this.buffer.charAt(n2)); ++n2) {
            }
            while (n3 > n2 && Tokenizer.isWhitespace(this.buffer.charAt(n3 - 1))) {
                --n3;
            }
            StringBuilder stringBuilder = new StringBuilder(n3 - n2);
            while (n2 < n3) {
                char c2 = this.buffer.charAt(n2);
                if (c2 == '\r' || c2 == '\n' || c2 == '\u0000') {
                    stringBuilder.append(' ');
                } else {
                    stringBuilder.append(c2);
                }
                ++n2;
            }
            this.value = stringBuilder.toString();
        }
        return this.value;
    }

    @Override
    public boolean isSensitive() {
        return false;
    }

    @Override
    public int getValuePos() {
        return this.valuePos;
    }

    @Override
    public CharArrayBuffer getBuffer() {
        return this.buffer;
    }

    public String toString() {
        return this.buffer.toString();
    }
}

