/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.FormattedHeader;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHeaderElementIterator;
import org.apache.hc.core5.http.message.BasicHeaderValueFormatter;
import org.apache.hc.core5.http.message.BasicHeaderValueParser;
import org.apache.hc.core5.http.message.BasicTokenIterator;
import org.apache.hc.core5.http.message.BufferedHeader;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.hc.core5.util.Tokenizer;
import org.apache.hc.core5.util.Tokenizer$Cursor;
import org.apache.hc.core5.util.Tokenizer$Delimiter;

public class MessageSupport {
    private static final Tokenizer$Delimiter COMMA = Tokenizer.delimiters(',');
    private static final Set<String> HOP_BY_HOP;

    private MessageSupport() {
    }

    public static void formatTokens(CharArrayBuffer charArrayBuffer, List<String> list) {
        Args.notNull(charArrayBuffer, "Destination");
        if (list == null) {
            return;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string = list.get(i2);
            if (i2 > 0) {
                charArrayBuffer.append(", ");
            }
            charArrayBuffer.append(string);
        }
    }

    public static void formatTokens(CharArrayBuffer charArrayBuffer, String ... stringArray) {
        Args.notNull(charArrayBuffer, "Destination");
        boolean bl2 = true;
        for (String string : stringArray) {
            if (!bl2) {
                charArrayBuffer.append(", ");
            }
            charArrayBuffer.append(string);
            bl2 = false;
        }
    }

    public static void formatTokens(CharArrayBuffer charArrayBuffer, Set<String> object) {
        Args.notNull(charArrayBuffer, "Destination");
        if (object == null) {
            return;
        }
        boolean bl2 = true;
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (!bl2) {
                charArrayBuffer.append(", ");
            }
            charArrayBuffer.append(string);
            bl2 = false;
        }
    }

    @Deprecated
    public static Header format(String string, Set<String> set) {
        return MessageSupport.header(string, set);
    }

    public static Header headerOfTokens(String string, List<String> list) {
        Args.notBlank(string, "Header name");
        if (list == null) {
            return null;
        }
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(256);
        charArrayBuffer.append(string);
        charArrayBuffer.append(": ");
        MessageSupport.formatTokens(charArrayBuffer, list);
        return BufferedHeader.create(charArrayBuffer);
    }

    public static Header header(String string, Set<String> set) {
        Args.notBlank(string, "Header name");
        if (set == null) {
            return null;
        }
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(256);
        charArrayBuffer.append(string);
        charArrayBuffer.append(": ");
        MessageSupport.formatTokens(charArrayBuffer, set);
        return BufferedHeader.create(charArrayBuffer);
    }

    public static Header header(String string, String ... stringArray) {
        Args.notBlank(string, "Header name");
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(256);
        charArrayBuffer.append(string);
        charArrayBuffer.append(": ");
        MessageSupport.formatTokens(charArrayBuffer, stringArray);
        return BufferedHeader.create(charArrayBuffer);
    }

    @Deprecated
    public static Header format(String string, String ... stringArray) {
        return MessageSupport.headerOfTokens(string, Arrays.asList(stringArray));
    }

    @Internal
    public static void parseHeader(Header header, BiConsumer<CharSequence, ParserCursor> biConsumer) {
        Args.notNull(header, "Header");
        if (header instanceof FormattedHeader) {
            CharArrayBuffer charArrayBuffer = ((FormattedHeader)header).getBuffer();
            ParserCursor parserCursor = new ParserCursor(0, charArrayBuffer.length());
            parserCursor.updatePos(((FormattedHeader)header).getValuePos());
            biConsumer.accept(charArrayBuffer, parserCursor);
            return;
        }
        String string = header.getValue();
        ParserCursor parserCursor = new ParserCursor(0, string.length());
        biConsumer.accept(string, parserCursor);
    }

    @Internal
    public static void parseHeaders(MessageHeaders object, String string, BiConsumer<CharSequence, ParserCursor> biConsumer) {
        Args.notNull(object, "Message headers");
        Args.notBlank(string, "Header name");
        object = object.headerIterator(string);
        while (object.hasNext()) {
            MessageSupport.parseHeader((Header)object.next(), biConsumer);
        }
    }

    @Internal
    public static void parseElementList(CharSequence charSequence, ParserCursor parserCursor, BiConsumer<CharSequence, ParserCursor> biConsumer) {
        Args.notNull(charSequence, "Source");
        Args.notNull(parserCursor, "Cursor");
        Args.notNull(biConsumer, "Consumer");
        while (!parserCursor.atEnd()) {
            char c2;
            biConsumer.accept(charSequence, parserCursor);
            if (parserCursor.atEnd() || (c2 = charSequence.charAt(parserCursor.getPos())) != ',') continue;
            ParserCursor parserCursor2 = parserCursor;
            parserCursor2.updatePos(parserCursor2.getPos() + 1);
        }
    }

    public static void parseTokens(CharSequence charSequence, ParserCursor parserCursor2, Consumer<String> consumer) {
        MessageSupport.parseElementList(charSequence, parserCursor2, (charSequence2, parserCursor) -> {
            charSequence = Tokenizer.INSTANCE.parseToken(charSequence, (Tokenizer$Cursor)parserCursor, COMMA);
            consumer.accept((String)charSequence);
        });
    }

    public static void parseTokens(Header header, Consumer<String> consumer) {
        Args.notNull(header, "Header");
        MessageSupport.parseHeader(header, (charSequence, parserCursor) -> MessageSupport.parseTokens(charSequence, parserCursor, consumer));
    }

    public static void parseTokens(MessageHeaders messageHeaders, String string, Consumer<String> consumer) {
        Args.notNull(messageHeaders, "Headers");
        MessageSupport.parseHeaders(messageHeaders, string, (charSequence, parserCursor) -> MessageSupport.parseTokens(charSequence, parserCursor, consumer));
    }

    public static Set<String> parseTokens(CharSequence charSequence, ParserCursor parserCursor) {
        Args.notNull(charSequence, "Source");
        Args.notNull(parserCursor, "Cursor");
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        MessageSupport.parseTokens(charSequence, parserCursor, linkedHashSet::add);
        return linkedHashSet;
    }

    public static Set<String> parseTokens(Header header) {
        Args.notNull(header, "Header");
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        MessageSupport.parseTokens(header, linkedHashSet::add);
        return linkedHashSet;
    }

    public static Iterator<String> iterateTokens(MessageHeaders messageHeaders, String string) {
        Args.notNull(messageHeaders, "Message headers");
        Args.notBlank(string, "Header name");
        return new BasicTokenIterator(messageHeaders.headerIterator(string));
    }

    public static void formatElements(CharArrayBuffer charArrayBuffer, List<HeaderElement> list) {
        Args.notNull(charArrayBuffer, "Destination");
        if (list == null) {
            return;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            HeaderElement headerElement = list.get(i2);
            if (i2 > 0) {
                charArrayBuffer.append(", ");
            }
            BasicHeaderValueFormatter.INSTANCE.formatHeaderElement(charArrayBuffer, headerElement, false);
        }
    }

    public static void formatElements(CharArrayBuffer charArrayBuffer, HeaderElement ... headerElementArray) {
        MessageSupport.formatElements(charArrayBuffer, Arrays.asList(headerElementArray));
    }

    public static Header headerOfElements(String string, List<HeaderElement> list) {
        Args.notBlank(string, "Header name");
        if (list == null) {
            return null;
        }
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(256);
        charArrayBuffer.append(string);
        charArrayBuffer.append(": ");
        MessageSupport.formatElements(charArrayBuffer, list);
        return BufferedHeader.create(charArrayBuffer);
    }

    public static Header header(String string, HeaderElement ... headerElementArray) {
        Args.notBlank(string, "Header name");
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(256);
        charArrayBuffer.append(string);
        charArrayBuffer.append(": ");
        MessageSupport.formatElements(charArrayBuffer, headerElementArray);
        return BufferedHeader.create(charArrayBuffer);
    }

    public static void parseElements(CharSequence charSequence2, ParserCursor parserCursor, Consumer<HeaderElement> consumer) {
        MessageSupport.parseElementList(charSequence2, parserCursor, (charSequence, parserCursor2) -> {
            charSequence2 = BasicHeaderValueParser.INSTANCE.parseHeaderElement(charSequence2, parserCursor);
            consumer.accept((HeaderElement)((Object)charSequence2));
        });
    }

    public static void parseElements(Header header, Consumer<HeaderElement> consumer) {
        Args.notNull(header, "Header");
        MessageSupport.parseHeader(header, (charSequence, parserCursor) -> MessageSupport.parseElements(charSequence, parserCursor, consumer));
    }

    public static void parseElements(MessageHeaders messageHeaders, String string, Consumer<HeaderElement> consumer) {
        Args.notNull(messageHeaders, "Headers");
        MessageSupport.parseHeaders(messageHeaders, string, (charSequence, parserCursor) -> MessageSupport.parseElements(charSequence, parserCursor, consumer));
    }

    @Deprecated
    public static HeaderElement[] parse(Header header) {
        ArrayList arrayList = new ArrayList();
        MessageSupport.parseElements(header, arrayList::add);
        return arrayList.toArray(new HeaderElement[0]);
    }

    public static List<HeaderElement> parseElements(Header header) {
        ArrayList<HeaderElement> arrayList = new ArrayList<HeaderElement>();
        MessageSupport.parseElements(header, arrayList::add);
        return arrayList;
    }

    public static Iterator<HeaderElement> iterate(MessageHeaders messageHeaders, String string) {
        Args.notNull(messageHeaders, "Message headers");
        Args.notBlank(string, "Header name");
        return new BasicHeaderElementIterator(messageHeaders.headerIterator(string));
    }

    public static void formatParameters(CharArrayBuffer charArrayBuffer, List<NameValuePair> list) {
        Args.notNull(charArrayBuffer, "Destination");
        if (list == null) {
            return;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            NameValuePair nameValuePair = list.get(i2);
            if (i2 > 0) {
                charArrayBuffer.append("; ");
            }
            BasicHeaderValueFormatter.INSTANCE.formatNameValuePair(charArrayBuffer, nameValuePair, false);
        }
    }

    public static void formatParameters(CharArrayBuffer charArrayBuffer, NameValuePair ... nameValuePairArray) {
        Args.notNull(charArrayBuffer, "Destination");
        if (nameValuePairArray == null) {
            return;
        }
        boolean bl2 = true;
        for (NameValuePair nameValuePair : nameValuePairArray) {
            if (!bl2) {
                charArrayBuffer.append("; ");
            }
            BasicHeaderValueFormatter.INSTANCE.formatNameValuePair(charArrayBuffer, nameValuePair, false);
            bl2 = false;
        }
    }

    public static void parseParameters(CharSequence charSequence, ParserCursor parserCursor, Consumer<NameValuePair> consumer) {
        Args.notNull(charSequence, "Source");
        Args.notNull(parserCursor, "Cursor");
        Args.notNull(consumer, "Consumer");
        while (!parserCursor.atEnd()) {
            NameValuePair nameValuePair = BasicHeaderValueParser.INSTANCE.parseNameValuePair(charSequence, parserCursor);
            consumer.accept(nameValuePair);
            if (parserCursor.atEnd()) continue;
            char c2 = charSequence.charAt(parserCursor.getPos());
            if (c2 == ';') {
                ParserCursor parserCursor2 = parserCursor;
                parserCursor2.updatePos(parserCursor2.getPos() + 1);
            }
            if (c2 != ',') continue;
        }
    }

    public static void addContentTypeHeader(HttpMessage httpMessage, EntityDetails entityDetails) {
        if (entityDetails != null && entityDetails.getContentType() != null && !httpMessage.containsHeader("Content-Type")) {
            httpMessage.addHeader(new BasicHeader("Content-Type", entityDetails.getContentType()));
        }
    }

    public static void addContentEncodingHeader(HttpMessage httpMessage, EntityDetails entityDetails) {
        if (entityDetails != null && entityDetails.getContentEncoding() != null && !httpMessage.containsHeader("Content-Encoding")) {
            httpMessage.addHeader(new BasicHeader("Content-Encoding", entityDetails.getContentEncoding()));
        }
    }

    public static void addTrailerHeader(HttpMessage httpMessage, EntityDetails object) {
        if (object != null && !httpMessage.containsHeader("Trailer") && (object = object.getTrailerNames()) != null && !object.isEmpty()) {
            httpMessage.setHeader(MessageSupport.header("Trailer", (Set<String>)object));
        }
    }

    public static boolean canResponseHaveBody(String string, HttpResponse httpResponse) {
        if (Method.HEAD.isSame(string)) {
            return false;
        }
        int n2 = httpResponse.getCode();
        if (Method.CONNECT.isSame(string) && n2 == 200) {
            return false;
        }
        return n2 >= 200 && n2 != 204 && n2 != 304;
    }

    public static boolean isHopByHop(String string) {
        if (string == null) {
            return false;
        }
        return HOP_BY_HOP.contains(string);
    }

    public static Set<String> hopByHopConnectionSpecific(MessageHeaders object) {
        Object object2 = (object = object.getFirstHeader("Connection")) != null ? object.getValue() : null;
        if (object2 != null && !((String)object2).equalsIgnoreCase("close") && !((String)object2).equalsIgnoreCase("keep-alive")) {
            object2 = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            ((TreeSet)object2).addAll(HOP_BY_HOP);
            ((TreeSet)object2).addAll(MessageSupport.parseTokens((Header)object));
            return object2;
        }
        return HOP_BY_HOP;
    }

    static {
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        treeSet.add("Connection");
        treeSet.add("Content-Length");
        treeSet.add("Transfer-Encoding");
        treeSet.add("Host");
        treeSet.add("Keep-Alive");
        treeSet.add("TE");
        treeSet.add("Upgrade");
        treeSet.add("Proxy-Authorization");
        treeSet.add("Proxy-Authentication-Info");
        treeSet.add("Proxy-Authenticate");
        HOP_BY_HOP = Collections.unmodifiableSet(treeSet);
    }
}

