/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.io.Serializable;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class RequestLine
implements Serializable {
    private static final long serialVersionUID = 2810581718468737193L;
    private final ProtocolVersion protoversion;
    private final String method;
    private final String uri;

    public RequestLine(HttpRequest httpRequest) {
        Args.notNull(httpRequest, "Request");
        this.method = httpRequest.getMethod();
        this.uri = httpRequest.getRequestUri();
        this.protoversion = httpRequest.getVersion() != null ? httpRequest.getVersion() : HttpVersion.HTTP_1_1;
    }

    public RequestLine(String string, String string2, ProtocolVersion protocolVersion) {
        this.method = Args.notNull(string, "Method");
        this.uri = Args.notNull(string2, "URI");
        this.protoversion = protocolVersion != null ? protocolVersion : HttpVersion.HTTP_1_1;
    }

    public final String getMethod() {
        return this.method;
    }

    public final ProtocolVersion getProtocolVersion() {
        return this.protoversion;
    }

    public final String getUri() {
        return this.uri;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.method).append(" ").append(this.uri).append(" ").append(this.protoversion);
        return stringBuilder.toString();
    }
}

