/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.StreamChannel;
import org.apache.hc.core5.http.nio.entity.AbstractBinAsyncEntityProducer$1;
import org.apache.hc.core5.http.nio.entity.AbstractBinAsyncEntityProducer$State;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public abstract class AbstractBinAsyncEntityProducer
implements AsyncEntityProducer {
    private final int fragmentSizeHint;
    private final ByteBuffer byteBuffer;
    private final ContentType contentType;
    private final ReentrantLock lock;
    private volatile AbstractBinAsyncEntityProducer$State state;

    public AbstractBinAsyncEntityProducer(int n2, ContentType contentType) {
        this.fragmentSizeHint = n2 >= 0 ? n2 : 0;
        this.byteBuffer = ByteBuffer.allocate(this.fragmentSizeHint);
        this.contentType = contentType;
        this.state = AbstractBinAsyncEntityProducer$State.ACTIVE;
        this.lock = new ReentrantLock();
    }

    private void flush(StreamChannel<ByteBuffer> streamChannel) throws IOException {
        if (this.byteBuffer.position() > 0) {
            this.byteBuffer.flip();
            streamChannel.write(this.byteBuffer);
            this.byteBuffer.compact();
        }
    }

    final int writeData(StreamChannel<ByteBuffer> streamChannel, ByteBuffer byteBuffer) throws IOException {
        int n2 = byteBuffer.remaining();
        if (n2 == 0) {
            return 0;
        }
        if (n2 > this.fragmentSizeHint) {
            this.flush(streamChannel);
            if (this.byteBuffer.position() == 0) {
                return streamChannel.write(byteBuffer);
            }
        } else {
            if (this.byteBuffer.remaining() < n2) {
                this.flush(streamChannel);
            }
            if (this.byteBuffer.remaining() >= n2) {
                this.byteBuffer.put(byteBuffer);
                if (!this.byteBuffer.hasRemaining()) {
                    this.flush(streamChannel);
                }
                return n2;
            }
        }
        return 0;
    }

    final void streamEnd(StreamChannel<ByteBuffer> streamChannel) throws IOException {
        if (this.state == AbstractBinAsyncEntityProducer$State.ACTIVE) {
            this.state = AbstractBinAsyncEntityProducer$State.FLUSHING;
            this.flush(streamChannel);
            if (this.byteBuffer.position() == 0) {
                this.state = AbstractBinAsyncEntityProducer$State.END_STREAM;
                streamChannel.endStream();
            }
        }
    }

    protected abstract int availableData();

    protected abstract void produceData(StreamChannel<ByteBuffer> var1) throws IOException;

    @Override
    public final String getContentType() {
        return Objects.toString(this.contentType, null);
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public Set<String> getTrailerNames() {
        return Collections.emptySet();
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public final int available() {
        if (this.state == AbstractBinAsyncEntityProducer$State.ACTIVE) {
            return this.availableData();
        }
        this.lock.lock();
        try {
            int n2 = this.byteBuffer.position();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final void produce(DataStreamChannel dataStreamChannel) throws IOException {
        this.lock.lock();
        try {
            if (this.state == AbstractBinAsyncEntityProducer$State.ACTIVE) {
                this.produceData(new AbstractBinAsyncEntityProducer$1(this, dataStreamChannel));
            }
            if (this.state == AbstractBinAsyncEntityProducer$State.FLUSHING) {
                this.flush(dataStreamChannel);
                if (this.byteBuffer.position() == 0) {
                    this.state = AbstractBinAsyncEntityProducer$State.END_STREAM;
                    dataStreamChannel.endStream();
                }
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void releaseResources() {
        this.state = AbstractBinAsyncEntityProducer$State.ACTIVE;
    }

    static /* synthetic */ ReentrantLock access$000(AbstractBinAsyncEntityProducer abstractBinAsyncEntityProducer) {
        return abstractBinAsyncEntityProducer.lock;
    }
}

