/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.entity.AbstractCharDataConsumer;
import org.apache.hc.core5.util.Args;

public abstract class AbstractCharAsyncEntityConsumer<T>
extends AbstractCharDataConsumer
implements AsyncEntityConsumer<T> {
    private volatile FutureCallback<T> resultCallback;
    private volatile T content;

    protected AbstractCharAsyncEntityConsumer(int n2, CharCodingConfig charCodingConfig) {
        super(n2, charCodingConfig);
    }

    public AbstractCharAsyncEntityConsumer() {
    }

    protected abstract void streamStart(ContentType var1) throws HttpException, IOException;

    protected abstract T generateContent() throws IOException;

    @Override
    public final void streamStart(EntityDetails entityDetails, FutureCallback<T> futureCallback) throws IOException, HttpException {
        Args.notNull(futureCallback, "Result callback");
        this.resultCallback = futureCallback;
        try {
            entityDetails = entityDetails != null ? ContentType.parse(entityDetails.getContentType()) : null;
            this.setCharset(ContentType.getCharset((ContentType)((Object)entityDetails), null));
            this.streamStart((ContentType)((Object)entityDetails));
            return;
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw new UnsupportedEncodingException(unsupportedCharsetException.getMessage());
        }
    }

    @Override
    protected final void completed() throws IOException {
        this.content = this.generateContent();
        if (this.resultCallback != null) {
            this.resultCallback.completed(this.content);
        }
        this.releaseResources();
    }

    @Override
    public final void failed(Exception exception) {
        if (this.resultCallback != null) {
            this.resultCallback.failed(exception);
        }
        this.releaseResources();
    }

    @Override
    public final T getContent() {
        return this.content;
    }
}

