/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.StreamChannel;
import org.apache.hc.core5.http.nio.entity.AbstractCharAsyncEntityProducer$1;
import org.apache.hc.core5.http.nio.entity.AbstractCharAsyncEntityProducer$State;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public abstract class AbstractCharAsyncEntityProducer
implements AsyncEntityProducer {
    private static final CharBuffer EMPTY = CharBuffer.wrap(new char[0]);
    private final ByteBuffer bytebuf;
    private final int fragmentSizeHint;
    private final ContentType contentType;
    private final CharsetEncoder charsetEncoder;
    private final ReentrantLock lock;
    private volatile AbstractCharAsyncEntityProducer$State state;

    public AbstractCharAsyncEntityProducer(int n2, int n3, ContentType contentType) {
        Args.positive(n2, "Buffer size");
        this.fragmentSizeHint = n3 >= 0 ? n3 : 0;
        this.bytebuf = ByteBuffer.allocate(n2);
        this.contentType = contentType;
        Charset charset = ContentType.getCharset(contentType, StandardCharsets.UTF_8);
        this.charsetEncoder = charset.newEncoder();
        this.state = AbstractCharAsyncEntityProducer$State.ACTIVE;
        this.lock = new ReentrantLock();
    }

    private void flush(StreamChannel<ByteBuffer> streamChannel) throws IOException {
        if (this.bytebuf.position() > 0) {
            this.bytebuf.flip();
            streamChannel.write(this.bytebuf);
            this.bytebuf.compact();
        }
    }

    final int writeData(StreamChannel<ByteBuffer> streamChannel, CharBuffer charBuffer) throws IOException {
        int n2 = charBuffer.remaining();
        if (n2 == 0) {
            return 0;
        }
        n2 = charBuffer.position();
        CoderResult coderResult = this.charsetEncoder.encode(charBuffer, this.bytebuf, false);
        if (coderResult.isError()) {
            coderResult.throwException();
        }
        if (!this.bytebuf.hasRemaining() || this.bytebuf.position() >= this.fragmentSizeHint) {
            this.flush(streamChannel);
        }
        return charBuffer.position() - n2;
    }

    final void streamEnd(StreamChannel<ByteBuffer> streamChannel) throws IOException {
        if (this.state == AbstractCharAsyncEntityProducer$State.ACTIVE) {
            CoderResult coderResult;
            CoderResult coderResult2;
            this.state = AbstractCharAsyncEntityProducer$State.FLUSHING;
            if (!this.bytebuf.hasRemaining()) {
                this.flush(streamChannel);
            }
            if ((coderResult2 = this.charsetEncoder.encode(EMPTY, this.bytebuf, true)).isError()) {
                coderResult2.throwException();
            }
            if ((coderResult = this.charsetEncoder.flush(this.bytebuf)).isError()) {
                coderResult2.throwException();
                return;
            }
            if (coderResult2.isUnderflow()) {
                this.flush(streamChannel);
                if (this.bytebuf.position() == 0) {
                    this.state = AbstractCharAsyncEntityProducer$State.END_STREAM;
                    streamChannel.endStream();
                }
            }
        }
    }

    protected abstract int availableData();

    protected abstract void produceData(StreamChannel<CharBuffer> var1) throws IOException;

    @Override
    public final String getContentType() {
        return Objects.toString(this.contentType, null);
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public Set<String> getTrailerNames() {
        return null;
    }

    @Override
    public final int available() {
        if (this.state == AbstractCharAsyncEntityProducer$State.ACTIVE) {
            return this.availableData();
        }
        this.lock.lock();
        try {
            int n2 = this.bytebuf.position();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final void produce(DataStreamChannel dataStreamChannel) throws IOException {
        this.lock.lock();
        try {
            if (this.state == AbstractCharAsyncEntityProducer$State.ACTIVE) {
                this.produceData(new AbstractCharAsyncEntityProducer$1(this, dataStreamChannel));
            }
            if (this.state == AbstractCharAsyncEntityProducer$State.FLUSHING) {
                CoderResult coderResult = this.charsetEncoder.flush(this.bytebuf);
                if (coderResult.isError()) {
                    coderResult.throwException();
                } else if (coderResult.isOverflow()) {
                    this.flush(dataStreamChannel);
                } else if (coderResult.isUnderflow()) {
                    this.flush(dataStreamChannel);
                    if (this.bytebuf.position() == 0) {
                        this.state = AbstractCharAsyncEntityProducer$State.END_STREAM;
                        dataStreamChannel.endStream();
                    }
                }
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void releaseResources() {
        this.state = AbstractCharAsyncEntityProducer$State.ACTIVE;
        this.charsetEncoder.reset();
    }

    static /* synthetic */ ReentrantLock access$000(AbstractCharAsyncEntityProducer abstractCharAsyncEntityProducer) {
        return abstractCharAsyncEntityProducer.lock;
    }
}

