/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.util.Args;

public class DigestingEntityConsumer<T>
implements AsyncEntityConsumer<T> {
    private final AsyncEntityConsumer<T> wrapped;
    private final List<Header> trailers;
    private final MessageDigest digester;
    private volatile byte[] digest;

    public DigestingEntityConsumer(String string, AsyncEntityConsumer<T> asyncEntityConsumer) throws NoSuchAlgorithmException {
        this.wrapped = Args.notNull(asyncEntityConsumer, "Entity consumer");
        this.trailers = new ArrayList<Header>();
        this.digester = MessageDigest.getInstance(string);
    }

    @Override
    public void streamStart(EntityDetails entityDetails, FutureCallback<T> futureCallback) throws IOException, HttpException {
        this.wrapped.streamStart(entityDetails, futureCallback);
    }

    @Override
    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.wrapped.updateCapacity(capacityChannel);
    }

    @Override
    public void consume(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.mark();
        this.digester.update(byteBuffer);
        byteBuffer.reset();
        this.wrapped.consume(byteBuffer);
    }

    @Override
    public void streamEnd(List<? extends Header> list) throws HttpException, IOException {
        if (list != null) {
            this.trailers.addAll(list);
        }
        this.digest = this.digester.digest();
        this.wrapped.streamEnd(list);
    }

    @Override
    public void failed(Exception exception) {
        this.wrapped.failed(exception);
    }

    @Override
    public T getContent() {
        return this.wrapped.getContent();
    }

    @Override
    public void releaseResources() {
        this.wrapped.releaseResources();
    }

    public List<Header> getTrailers() {
        if (this.trailers != null) {
            return new ArrayList<Header>(this.trailers);
        }
        return null;
    }

    public byte[] getDigest() {
        return this.digest;
    }
}

