/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.entity.DigestingEntityProducer$1;
import org.apache.hc.core5.util.Args;

public class DigestingEntityProducer
implements AsyncEntityProducer {
    private final AsyncEntityProducer wrapped;
    private final MessageDigest digester;
    private volatile byte[] digest;

    public DigestingEntityProducer(String string, AsyncEntityProducer asyncEntityProducer) {
        this.wrapped = Args.notNull(asyncEntityProducer, "Entity consumer");
        try {
            this.digester = MessageDigest.getInstance(string);
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException("Unsupported digest algorithm: " + string);
        }
    }

    @Override
    public boolean isRepeatable() {
        return this.wrapped.isRepeatable();
    }

    @Override
    public long getContentLength() {
        return this.wrapped.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.wrapped.getContentType();
    }

    @Override
    public String getContentEncoding() {
        return this.wrapped.getContentEncoding();
    }

    @Override
    public boolean isChunked() {
        return this.wrapped.isChunked();
    }

    @Override
    public Set<String> getTrailerNames() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        Set<String> set = this.wrapped.getTrailerNames();
        if (set != null) {
            linkedHashSet.addAll(set);
        }
        linkedHashSet.add("digest-algo");
        linkedHashSet.add("digest");
        return linkedHashSet;
    }

    @Override
    public int available() {
        return this.wrapped.available();
    }

    @Override
    public void produce(DataStreamChannel dataStreamChannel) throws IOException {
        this.wrapped.produce(new DigestingEntityProducer$1(this, dataStreamChannel));
    }

    @Override
    public void failed(Exception exception) {
        this.wrapped.failed(exception);
    }

    @Override
    public void releaseResources() {
        this.wrapped.releaseResources();
    }

    public byte[] getDigest() {
        return this.digest;
    }

    static /* synthetic */ MessageDigest access$000(DigestingEntityProducer digestingEntityProducer) {
        return digestingEntityProducer.digester;
    }

    static /* synthetic */ byte[] access$102(DigestingEntityProducer digestingEntityProducer, byte[] byArray) {
        digestingEntityProducer.digest = byArray;
        return byArray;
    }

    static /* synthetic */ byte[] access$100(DigestingEntityProducer digestingEntityProducer) {
        return digestingEntityProducer.digest;
    }
}

