/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;

public final class DiscardingEntityConsumer<T>
implements AsyncEntityConsumer<T> {
    private volatile FutureCallback<T> resultCallback;

    @Override
    public final void streamStart(EntityDetails entityDetails, FutureCallback<T> futureCallback) throws IOException, HttpException {
        this.resultCallback = futureCallback;
    }

    @Override
    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        capacityChannel.update(Integer.MAX_VALUE);
    }

    @Override
    public final void consume(ByteBuffer byteBuffer) throws IOException {
    }

    @Override
    public final void streamEnd(List<? extends Header> list) throws IOException {
        if (this.resultCallback != null) {
            this.resultCallback.completed(null);
        }
    }

    @Override
    public final void failed(Exception exception) {
        if (this.resultCallback != null) {
            this.resultCallback.failed(exception);
        }
    }

    @Override
    public final T getContent() {
        return null;
    }

    @Override
    public final void releaseResources() {
    }
}

