/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;

public final class FileEntityProducer
implements AsyncEntityProducer {
    private final File file;
    private final ByteBuffer byteBuffer;
    private final long length;
    private final ContentType contentType;
    private final boolean chunked;
    private final AtomicReference<Exception> exception;
    private final AtomicReference<RandomAccessFile> accessFileRef;
    private boolean eof;

    public FileEntityProducer(File file, int n2, ContentType contentType, boolean bl2) {
        this.file = Args.notNull(file, "File");
        this.length = file.length();
        this.byteBuffer = ByteBuffer.allocate(n2);
        this.contentType = contentType;
        this.chunked = bl2;
        this.accessFileRef = new AtomicReference();
        this.exception = new AtomicReference();
    }

    public FileEntityProducer(File file, ContentType contentType, boolean bl2) {
        this(file, 8192, contentType, bl2);
    }

    public FileEntityProducer(File file, ContentType contentType) {
        this(file, contentType, false);
    }

    public FileEntityProducer(File file) {
        this(file, ContentType.APPLICATION_OCTET_STREAM);
    }

    @Override
    public final boolean isRepeatable() {
        return true;
    }

    @Override
    public final String getContentType() {
        return Objects.toString(this.contentType, null);
    }

    @Override
    public final long getContentLength() {
        return this.length;
    }

    @Override
    public final int available() {
        return Integer.MAX_VALUE;
    }

    @Override
    public final String getContentEncoding() {
        return null;
    }

    @Override
    public final boolean isChunked() {
        return this.chunked;
    }

    @Override
    public final Set<String> getTrailerNames() {
        return Collections.emptySet();
    }

    @Override
    public final void produce(DataStreamChannel dataStreamChannel) throws IOException {
        int n2;
        RandomAccessFile randomAccessFile = this.accessFileRef.get();
        if (randomAccessFile == null) {
            randomAccessFile = new RandomAccessFile(this.file, "r");
            Asserts.check(this.accessFileRef.getAndSet(randomAccessFile) == null, "Illegal producer state");
        }
        if (!this.eof && (n2 = randomAccessFile.getChannel().read(this.byteBuffer)) < 0) {
            this.eof = true;
        }
        if (this.byteBuffer.position() > 0) {
            this.byteBuffer.flip();
            dataStreamChannel.write(this.byteBuffer);
            this.byteBuffer.compact();
        }
        if (this.eof && this.byteBuffer.position() == 0) {
            dataStreamChannel.endStream();
            this.releaseResources();
        }
    }

    @Override
    public final void failed(Exception exception) {
        if (this.exception.compareAndSet(null, exception)) {
            this.releaseResources();
        }
    }

    public final Exception getException() {
        return this.exception.get();
    }

    @Override
    public final void releaseResources() {
        this.eof = false;
        Closer.closeQuietly(this.accessFileRef.getAndSet(null));
    }
}

