/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.IOException;
import java.nio.CharBuffer;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.nio.entity.AbstractCharAsyncEntityConsumer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;

public class StringAsyncEntityConsumer
extends AbstractCharAsyncEntityConsumer<String> {
    private final int capacityIncrement;
    private final CharArrayBuffer content;

    public StringAsyncEntityConsumer(int n2, int n3, CharCodingConfig charCodingConfig) {
        super(n2, charCodingConfig);
        this.capacityIncrement = Args.positive(n3, "Capacity increment");
        this.content = new CharArrayBuffer(1024);
    }

    public StringAsyncEntityConsumer(int n2) {
        this(8192, n2, CharCodingConfig.DEFAULT);
    }

    public StringAsyncEntityConsumer(CharCodingConfig charCodingConfig) {
        this(8192, Integer.MAX_VALUE, charCodingConfig);
    }

    public StringAsyncEntityConsumer() {
        this(Integer.MAX_VALUE);
    }

    @Override
    protected final void streamStart(ContentType contentType) throws HttpException, IOException {
    }

    @Override
    protected int capacityIncrement() {
        int n2 = this.content.capacity() - this.content.length();
        return Math.max(this.capacityIncrement, n2);
    }

    @Override
    protected final void data(CharBuffer charBuffer, boolean bl2) {
        Args.notNull(charBuffer, "CharBuffer");
        int n2 = charBuffer.remaining();
        this.content.ensureCapacity(n2);
        charBuffer.get(this.content.array(), this.content.length(), n2);
        this.content.setLength(this.content.length() + n2);
    }

    @Override
    public String generateContent() {
        return this.content.toString();
    }

    @Override
    public void releaseResources() {
        this.content.clear();
    }
}

