/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.support.AbstractAsyncPushHandler$1;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

public abstract class AbstractAsyncPushHandler<T>
implements AsyncPushConsumer {
    private final AsyncResponseConsumer<T> responseConsumer;
    private final AtomicReference<HttpRequest> promiseRef;

    public AbstractAsyncPushHandler(AsyncResponseConsumer<T> asyncResponseConsumer) {
        this.responseConsumer = Args.notNull(asyncResponseConsumer, "Response consumer");
        this.promiseRef = new AtomicReference();
    }

    protected abstract void handleResponse(HttpRequest var1, T var2) throws IOException, HttpException;

    protected void handleError(HttpRequest httpRequest, Exception exception) {
    }

    @Override
    public final void consumePromise(HttpRequest httpRequest, HttpResponse httpResponse, EntityDetails entityDetails, HttpContext httpContext) throws HttpException, IOException {
        this.promiseRef.compareAndSet(null, httpRequest);
        this.responseConsumer.consumeResponse(httpResponse, entityDetails, httpContext, new AbstractAsyncPushHandler$1(this, httpRequest));
    }

    @Override
    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.responseConsumer.updateCapacity(capacityChannel);
    }

    @Override
    public final void consume(ByteBuffer byteBuffer) throws IOException {
        this.responseConsumer.consume(byteBuffer);
    }

    @Override
    public final void streamEnd(List<? extends Header> list) throws HttpException, IOException {
        this.responseConsumer.streamEnd(list);
    }

    @Override
    public final void failed(Exception exception) {
        this.responseConsumer.failed(exception);
        AbstractAsyncPushHandler abstractAsyncPushHandler = this;
        abstractAsyncPushHandler.handleError(abstractAsyncPushHandler.promiseRef.get(), exception);
        this.releaseResources();
    }

    @Override
    public final void releaseResources() {
        if (this.responseConsumer != null) {
            this.responseConsumer.releaseResources();
        }
    }
}

