/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncRequestConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.support.AbstractAsyncRequesterConsumer$1;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

public abstract class AbstractAsyncRequesterConsumer<T, E>
implements AsyncRequestConsumer<T> {
    private final Supplier<AsyncEntityConsumer<E>> dataConsumerSupplier;
    private final AtomicReference<AsyncEntityConsumer<E>> dataConsumerRef;

    public AbstractAsyncRequesterConsumer(Supplier<AsyncEntityConsumer<E>> supplier) {
        this.dataConsumerSupplier = Args.notNull(supplier, "Data consumer supplier");
        this.dataConsumerRef = new AtomicReference();
    }

    public AbstractAsyncRequesterConsumer(AsyncEntityConsumer<E> asyncEntityConsumer) {
        this(() -> asyncEntityConsumer);
    }

    protected abstract T buildResult(HttpRequest var1, E var2, ContentType var3);

    @Override
    public final void consumeRequest(HttpRequest httpRequest, EntityDetails entityDetails, HttpContext asyncEntityConsumer, FutureCallback<T> futureCallback) throws HttpException, IOException {
        if (entityDetails != null) {
            asyncEntityConsumer = this.dataConsumerSupplier.get();
            if (asyncEntityConsumer == null) {
                throw new HttpException("Supplied data consumer is null");
            }
            this.dataConsumerRef.set(asyncEntityConsumer);
            asyncEntityConsumer.streamStart(entityDetails, new AbstractAsyncRequesterConsumer$1(this, futureCallback, entityDetails, httpRequest, futureCallback));
            return;
        }
        futureCallback.completed(this.buildResult(httpRequest, null, null));
    }

    @Override
    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        AsyncEntityConsumer<E> asyncEntityConsumer = this.dataConsumerRef.get();
        asyncEntityConsumer.updateCapacity(capacityChannel);
    }

    @Override
    public final void consume(ByteBuffer byteBuffer) throws IOException {
        AsyncEntityConsumer<E> asyncEntityConsumer = this.dataConsumerRef.get();
        asyncEntityConsumer.consume(byteBuffer);
    }

    @Override
    public final void streamEnd(List<? extends Header> list) throws HttpException, IOException {
        AsyncEntityConsumer<E> asyncEntityConsumer = this.dataConsumerRef.get();
        asyncEntityConsumer.streamEnd(list);
    }

    @Override
    public final void failed(Exception exception) {
        this.releaseResources();
    }

    @Override
    public final void releaseResources() {
        AsyncEntityConsumer asyncEntityConsumer = this.dataConsumerRef.getAndSet(null);
        if (asyncEntityConsumer != null) {
            asyncEntityConsumer.releaseResources();
        }
    }
}

