/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import java.io.IOException;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncPushProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.ResponseChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

public class BasicPushProducer
implements AsyncPushProducer {
    private final HttpResponse response;
    private final AsyncEntityProducer dataProducer;

    public BasicPushProducer(HttpResponse httpResponse, AsyncEntityProducer asyncEntityProducer) {
        this.response = Args.notNull(httpResponse, "Response");
        this.dataProducer = Args.notNull(asyncEntityProducer, "Entity producer");
    }

    public BasicPushProducer(int n2, AsyncEntityProducer asyncEntityProducer) {
        this(new BasicHttpResponse(n2), asyncEntityProducer);
    }

    public BasicPushProducer(AsyncEntityProducer asyncEntityProducer) {
        this(200, asyncEntityProducer);
    }

    @Override
    public void produceResponse(ResponseChannel responseChannel, HttpContext httpContext) throws HttpException, IOException {
        responseChannel.sendResponse(this.response, this.dataProducer, httpContext);
    }

    @Override
    public int available() {
        if (this.dataProducer != null) {
            return this.dataProducer.available();
        }
        return 0;
    }

    @Override
    public void produce(DataStreamChannel dataStreamChannel) throws IOException {
        if (this.dataProducer != null) {
            this.dataProducer.produce(dataStreamChannel);
        }
    }

    @Override
    public void failed(Exception exception) {
        this.releaseResources();
    }

    @Override
    public void releaseResources() {
        if (this.dataProducer != null) {
            this.dataProducer.releaseResources();
        }
    }
}

