/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncRequestConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.support.BasicRequestConsumer$1;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

public class BasicRequestConsumer<T>
implements AsyncRequestConsumer<Message<HttpRequest, T>> {
    private final Supplier<AsyncEntityConsumer<T>> dataConsumerSupplier;
    private final AtomicReference<AsyncEntityConsumer<T>> dataConsumerRef;

    public BasicRequestConsumer(Supplier<AsyncEntityConsumer<T>> supplier) {
        this.dataConsumerSupplier = Args.notNull(supplier, "Data consumer supplier");
        this.dataConsumerRef = new AtomicReference();
    }

    public BasicRequestConsumer(AsyncEntityConsumer<T> asyncEntityConsumer) {
        this(() -> asyncEntityConsumer);
    }

    @Override
    public void consumeRequest(HttpRequest httpRequest, EntityDetails entityDetails, HttpContext asyncEntityConsumer, FutureCallback<Message<HttpRequest, T>> futureCallback) throws HttpException, IOException {
        Args.notNull(httpRequest, "Request");
        if (entityDetails != null) {
            asyncEntityConsumer = this.dataConsumerSupplier.get();
            if (asyncEntityConsumer == null) {
                throw new HttpException("Supplied data consumer is null");
            }
            this.dataConsumerRef.set(asyncEntityConsumer);
            FutureCallback futureCallback2 = futureCallback;
            asyncEntityConsumer.streamStart(entityDetails, new BasicRequestConsumer$1(this, futureCallback2, futureCallback2, httpRequest));
            return;
        }
        if (futureCallback != null) {
            futureCallback.completed(new Message(httpRequest));
        }
    }

    @Override
    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        AsyncEntityConsumer<T> asyncEntityConsumer = this.dataConsumerRef.get();
        asyncEntityConsumer.updateCapacity(capacityChannel);
    }

    @Override
    public void consume(ByteBuffer byteBuffer) throws IOException {
        AsyncEntityConsumer<T> asyncEntityConsumer = this.dataConsumerRef.get();
        asyncEntityConsumer.consume(byteBuffer);
    }

    @Override
    public void streamEnd(List<? extends Header> list) throws HttpException, IOException {
        AsyncEntityConsumer<T> asyncEntityConsumer = this.dataConsumerRef.get();
        asyncEntityConsumer.streamEnd(list);
    }

    @Override
    public void failed(Exception exception) {
        this.releaseResources();
    }

    @Override
    public void releaseResources() {
        AsyncEntityConsumer asyncEntityConsumer = this.dataConsumerRef.getAndSet(null);
        if (asyncEntityConsumer != null) {
            asyncEntityConsumer.releaseResources();
        }
    }
}

