/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.support.BasicResponseConsumer$1;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

public class BasicResponseConsumer<T>
implements AsyncResponseConsumer<Message<HttpResponse, T>> {
    private final Supplier<AsyncEntityConsumer<T>> dataConsumerSupplier;
    private final AtomicReference<AsyncEntityConsumer<T>> dataConsumerRef;

    public BasicResponseConsumer(Supplier<AsyncEntityConsumer<T>> supplier) {
        this.dataConsumerSupplier = Args.notNull(supplier, "Data consumer supplier");
        this.dataConsumerRef = new AtomicReference();
    }

    public BasicResponseConsumer(AsyncEntityConsumer<T> asyncEntityConsumer) {
        this(() -> asyncEntityConsumer);
    }

    @Override
    public void consumeResponse(HttpResponse httpResponse, EntityDetails entityDetails, HttpContext asyncEntityConsumer, FutureCallback<Message<HttpResponse, T>> futureCallback) throws HttpException, IOException {
        Args.notNull(httpResponse, "Response");
        if (entityDetails != null) {
            asyncEntityConsumer = this.dataConsumerSupplier.get();
            if (asyncEntityConsumer == null) {
                throw new HttpException("Supplied data consumer is null");
            }
            this.dataConsumerRef.set(asyncEntityConsumer);
            FutureCallback futureCallback2 = futureCallback;
            asyncEntityConsumer.streamStart(entityDetails, new BasicResponseConsumer$1(this, futureCallback2, futureCallback2, httpResponse));
            return;
        }
        if (futureCallback != null) {
            futureCallback.completed(new Message(httpResponse));
        }
    }

    @Override
    public void informationResponse(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
    }

    @Override
    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        AsyncEntityConsumer<T> asyncEntityConsumer = this.dataConsumerRef.get();
        asyncEntityConsumer.updateCapacity(capacityChannel);
    }

    @Override
    public void consume(ByteBuffer byteBuffer) throws IOException {
        AsyncEntityConsumer<T> asyncEntityConsumer = this.dataConsumerRef.get();
        asyncEntityConsumer.consume(byteBuffer);
    }

    @Override
    public void streamEnd(List<? extends Header> list) throws HttpException, IOException {
        AsyncEntityConsumer<T> asyncEntityConsumer = this.dataConsumerRef.get();
        asyncEntityConsumer.streamEnd(list);
    }

    @Override
    public void failed(Exception exception) {
        AsyncEntityConsumer<T> asyncEntityConsumer = this.dataConsumerRef.get();
        if (asyncEntityConsumer != null) {
            asyncEntityConsumer.failed(exception);
        }
        this.releaseResources();
    }

    @Override
    public void releaseResources() {
        AsyncEntityConsumer asyncEntityConsumer = this.dataConsumerRef.getAndSet(null);
        if (asyncEntityConsumer != null) {
            asyncEntityConsumer.releaseResources();
        }
    }
}

