/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.MisdirectedRequestException;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.support.ImmediateResponseExchangeHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

public final class DefaultAsyncResponseExchangeHandlerFactory
implements HandlerFactory<AsyncServerExchangeHandler> {
    private final HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> mapper;
    private final Decorator<AsyncServerExchangeHandler> decorator;

    public DefaultAsyncResponseExchangeHandlerFactory(HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> httpRequestMapper, Decorator<AsyncServerExchangeHandler> decorator) {
        this.mapper = Args.notNull(httpRequestMapper, "Request handler mapper");
        this.decorator = decorator;
    }

    public DefaultAsyncResponseExchangeHandlerFactory(HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> httpRequestMapper) {
        this(httpRequestMapper, null);
    }

    private AsyncServerExchangeHandler createHandler(HttpRequest object, HttpContext httpContext) throws HttpException {
        try {
            object = this.mapper.resolve((HttpRequest)object, httpContext);
            if (object != null) {
                return (AsyncServerExchangeHandler)object.get();
            }
            return new ImmediateResponseExchangeHandler(404, "Resource not found");
        }
        catch (MisdirectedRequestException misdirectedRequestException) {
            return new ImmediateResponseExchangeHandler(421, "Not authoritative");
        }
    }

    @Override
    public final AsyncServerExchangeHandler create(HttpRequest object, HttpContext httpContext) throws HttpException {
        if ((object = this.createHandler((HttpRequest)object, httpContext)) != null) {
            if (this.decorator != null) {
                return this.decorator.decorate((AsyncServerExchangeHandler)object);
            }
            return object;
        }
        return null;
    }
}

