/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.nio.AsyncResponseProducer;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.ResponseChannel;
import org.apache.hc.core5.http.nio.entity.AsyncEntityProducers;
import org.apache.hc.core5.http.nio.support.BasicResponseProducer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

public final class ImmediateResponseExchangeHandler
implements AsyncServerExchangeHandler {
    private final AsyncResponseProducer responseProducer;

    public ImmediateResponseExchangeHandler(AsyncResponseProducer asyncResponseProducer) {
        this.responseProducer = Args.notNull(asyncResponseProducer, "Response producer");
    }

    public ImmediateResponseExchangeHandler(HttpResponse httpResponse, String string) {
        this(new BasicResponseProducer(httpResponse, AsyncEntityProducers.create(string)));
    }

    public ImmediateResponseExchangeHandler(int n2, String string) {
        this(new BasicHttpResponse(n2), string);
    }

    @Override
    public final void handleRequest(HttpRequest httpRequest, EntityDetails entityDetails, ResponseChannel responseChannel, HttpContext httpContext) throws HttpException, IOException {
        this.responseProducer.sendResponse(responseChannel, httpContext);
    }

    @Override
    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        capacityChannel.update(Integer.MAX_VALUE);
    }

    @Override
    public final void consume(ByteBuffer byteBuffer) throws IOException {
    }

    @Override
    public final void streamEnd(List<? extends Header> list) throws HttpException, IOException {
    }

    @Override
    public final int available() {
        return this.responseProducer.available();
    }

    @Override
    public final void produce(DataStreamChannel dataStreamChannel) throws IOException {
        this.responseProducer.produce(dataStreamChannel);
    }

    @Override
    public final void failed(Exception exception) {
        this.responseProducer.failed(exception);
        this.releaseResources();
    }

    @Override
    public final void releaseResources() {
        this.responseProducer.releaseResources();
    }
}

