/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support.classic;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.support.classic.AbstractClassicEntityConsumer$State;
import org.apache.hc.core5.http.nio.support.classic.ContentInputStream;
import org.apache.hc.core5.http.nio.support.classic.SharedInputBuffer;
import org.apache.hc.core5.util.Args;

public abstract class AbstractClassicEntityConsumer<T>
implements AsyncEntityConsumer<T> {
    private final Executor executor;
    private final SharedInputBuffer buffer;
    private final AtomicReference<AbstractClassicEntityConsumer$State> state;
    private final AtomicReference<T> resultRef;
    private final AtomicReference<Exception> exceptionRef;

    public AbstractClassicEntityConsumer(int n2, Executor executor) {
        this.executor = Args.notNull(executor, "Executor");
        this.buffer = new SharedInputBuffer(n2);
        this.state = new AtomicReference<AbstractClassicEntityConsumer$State>(AbstractClassicEntityConsumer$State.IDLE);
        this.resultRef = new AtomicReference();
        this.exceptionRef = new AtomicReference();
    }

    protected abstract T consumeData(ContentType var1, InputStream var2) throws IOException;

    @Override
    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.buffer.updateCapacity(capacityChannel);
    }

    @Override
    public final void streamStart(EntityDetails object, FutureCallback<T> futureCallback) throws HttpException, IOException {
        try {
            object = ContentType.parse(object.getContentType());
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw new UnsupportedEncodingException(unsupportedCharsetException.getMessage());
        }
        if (this.state.compareAndSet(AbstractClassicEntityConsumer$State.IDLE, AbstractClassicEntityConsumer$State.ACTIVE)) {
            this.executor.execute(() -> this.lambda$streamStart$0((ContentType)object, futureCallback));
        }
    }

    @Override
    public final void consume(ByteBuffer byteBuffer) throws IOException {
        this.buffer.fill(byteBuffer);
    }

    @Override
    public final void streamEnd(List<? extends Header> list) throws HttpException, IOException {
        this.buffer.markEndStream();
    }

    @Override
    public final void failed(Exception exception) {
        if (this.exceptionRef.compareAndSet(null, exception)) {
            this.releaseResources();
        }
    }

    public final Exception getException() {
        return this.exceptionRef.get();
    }

    @Override
    public final T getContent() {
        return this.resultRef.get();
    }

    @Override
    public void releaseResources() {
    }

    private /* synthetic */ void lambda$streamStart$0(ContentType contentType, FutureCallback futureCallback) {
        try {
            contentType = this.consumeData(contentType, new ContentInputStream(this.buffer));
            this.resultRef.set(contentType);
            futureCallback.completed(contentType);
            return;
        }
        catch (Exception exception) {
            this.buffer.abort();
            futureCallback.failed(exception);
            return;
        }
        finally {
            this.state.set(AbstractClassicEntityConsumer$State.COMPLETED);
        }
    }
}

