/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support.classic;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.support.classic.AbstractClassicEntityProducer$State;
import org.apache.hc.core5.http.nio.support.classic.ContentOutputStream;
import org.apache.hc.core5.http.nio.support.classic.SharedOutputBuffer;
import org.apache.hc.core5.util.Args;

public abstract class AbstractClassicEntityProducer
implements AsyncEntityProducer {
    private final SharedOutputBuffer buffer;
    private final ContentType contentType;
    private final Executor executor;
    private final AtomicReference<AbstractClassicEntityProducer$State> state;
    private final AtomicReference<Exception> exception;

    public AbstractClassicEntityProducer(int n2, ContentType contentType, Executor executor) {
        this.buffer = new SharedOutputBuffer(n2);
        this.contentType = contentType;
        this.executor = Args.notNull(executor, "Executor");
        this.state = new AtomicReference<AbstractClassicEntityProducer$State>(AbstractClassicEntityProducer$State.IDLE);
        this.exception = new AtomicReference();
    }

    protected abstract void produceData(ContentType var1, OutputStream var2) throws IOException;

    @Override
    public final boolean isRepeatable() {
        return false;
    }

    @Override
    public final int available() {
        return this.buffer.length();
    }

    @Override
    public final void produce(DataStreamChannel dataStreamChannel) throws IOException {
        if (this.state.compareAndSet(AbstractClassicEntityProducer$State.IDLE, AbstractClassicEntityProducer$State.ACTIVE)) {
            this.executor.execute(() -> {
                try {
                    AbstractClassicEntityProducer abstractClassicEntityProducer = this;
                    abstractClassicEntityProducer.produceData(abstractClassicEntityProducer.contentType, new ContentOutputStream(this.buffer));
                    this.buffer.writeCompleted();
                    return;
                }
                catch (Exception exception) {
                    this.buffer.abort();
                    return;
                }
                finally {
                    this.state.set(AbstractClassicEntityProducer$State.COMPLETED);
                }
            });
        }
        this.buffer.flush(dataStreamChannel);
    }

    @Override
    public final long getContentLength() {
        return -1L;
    }

    @Override
    public final String getContentType() {
        return Objects.toString(this.contentType, null);
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public final boolean isChunked() {
        return false;
    }

    @Override
    public final Set<String> getTrailerNames() {
        return null;
    }

    @Override
    public final void failed(Exception exception) {
        if (this.exception.compareAndSet(null, exception)) {
            this.releaseResources();
        }
    }

    public final Exception getException() {
        return this.exception.get();
    }

    @Override
    public void releaseResources() {
    }
}

