/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support.classic;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hc.core5.http.nio.support.classic.ContentOutputBuffer;
import org.apache.hc.core5.util.Args;

public class ContentOutputStream
extends OutputStream {
    private final ContentOutputBuffer buffer;

    public ContentOutputStream(ContentOutputBuffer contentOutputBuffer) {
        Args.notNull(contentOutputBuffer, "Output buffer");
        this.buffer = contentOutputBuffer;
    }

    @Override
    public void close() throws IOException {
        this.buffer.writeCompleted();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.buffer.write(byArray, n2, n3);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        if (byArray == null) {
            return;
        }
        this.buffer.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n2) throws IOException {
        this.buffer.write(n2);
    }
}

