/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support.classic;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.support.classic.AbstractSharedBuffer;
import org.apache.hc.core5.http.nio.support.classic.ContentInputBuffer;

@Contract(threading=ThreadingBehavior.SAFE)
public final class SharedInputBuffer
extends AbstractSharedBuffer
implements ContentInputBuffer {
    private final int initialBufferSize;
    private final AtomicInteger capacityIncrement;
    private volatile CapacityChannel capacityChannel;

    public SharedInputBuffer(ReentrantLock reentrantLock, int n2) {
        super(reentrantLock, n2);
        this.initialBufferSize = n2;
        this.capacityIncrement = new AtomicInteger(0);
    }

    public SharedInputBuffer(int n2) {
        this(new ReentrantLock(), n2);
    }

    public final int fill(ByteBuffer byteBuffer) {
        this.lock.lock();
        try {
            this.setInputMode();
            SharedInputBuffer sharedInputBuffer = this;
            sharedInputBuffer.ensureAdjustedCapacity(sharedInputBuffer.buffer().position() + byteBuffer.remaining());
            this.buffer().put(byteBuffer);
            int n2 = this.buffer().remaining();
            this.condition.signalAll();
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void incrementCapacity() throws IOException {
        int n2;
        if (this.capacityChannel != null && (n2 = this.capacityIncrement.getAndSet(0)) > 0) {
            this.capacityChannel.update(n2);
        }
    }

    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.lock.lock();
        try {
            this.capacityChannel = capacityChannel;
            this.setInputMode();
            if (this.buffer().position() == 0) {
                capacityChannel.update(this.initialBufferSize);
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void awaitInput() throws InterruptedIOException {
        if (!this.buffer().hasRemaining()) {
            this.setInputMode();
            while (this.buffer().position() == 0 && !this.endStream && !this.aborted) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException(interruptedException.getMessage());
                }
            }
            this.setOutputMode();
        }
    }

    private void ensureNotAborted() throws InterruptedIOException {
        if (this.aborted) {
            throw new InterruptedIOException("Operation aborted");
        }
    }

    @Override
    public final int read() throws IOException {
        this.lock.lock();
        try {
            this.setOutputMode();
            this.awaitInput();
            this.ensureNotAborted();
            if (!this.buffer().hasRemaining() && this.endStream) {
                return -1;
            }
            int n2 = this.buffer().get() & 0xFF;
            this.capacityIncrement.incrementAndGet();
            if (!this.buffer().hasRemaining()) {
                this.incrementCapacity();
            }
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 == 0) {
            return 0;
        }
        this.lock.lock();
        try {
            this.setOutputMode();
            this.awaitInput();
            this.ensureNotAborted();
            if (!this.buffer().hasRemaining() && this.endStream) {
                return -1;
            }
            n3 = Math.min(this.buffer().remaining(), n3);
            this.buffer().get(byArray, n2, n3);
            this.capacityIncrement.addAndGet(n3);
            if (!this.buffer().hasRemaining()) {
                this.incrementCapacity();
            }
            int n4 = n3;
            return n4;
        }
        finally {
            this.lock.unlock();
        }
    }

    public final void markEndStream() {
        if (this.endStream) {
            return;
        }
        this.lock.lock();
        try {
            if (!this.endStream) {
                this.endStream = true;
                this.capacityChannel = null;
                this.condition.signalAll();
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }
}

