/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

final class ChainBuilder<E> {
    private final LinkedList<E> list = new LinkedList();
    private final Map<Class<?>, E> uniqueClasses = new HashMap();

    private void ensureUnique(E e2) {
        E e3 = this.uniqueClasses.remove(e2.getClass());
        if (e3 != null) {
            this.list.remove(e3);
        }
        this.uniqueClasses.put(e2.getClass(), e2);
    }

    public final ChainBuilder<E> addFirst(E e2) {
        if (e2 == null) {
            return this;
        }
        this.ensureUnique(e2);
        this.list.addFirst(e2);
        return this;
    }

    public final ChainBuilder<E> addLast(E e2) {
        if (e2 == null) {
            return this;
        }
        this.ensureUnique(e2);
        this.list.addLast(e2);
        return this;
    }

    public final ChainBuilder<E> addAllFirst(Collection<E> object) {
        if (object == null) {
            return this;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            this.addFirst(e2);
        }
        return this;
    }

    @SafeVarargs
    public final ChainBuilder<E> addAllFirst(E ... EArray) {
        if (EArray == null) {
            return this;
        }
        for (E e2 : EArray) {
            this.addFirst(e2);
        }
        return this;
    }

    public final ChainBuilder<E> addAllLast(Collection<E> object) {
        if (object == null) {
            return this;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            this.addLast(e2);
        }
        return this;
    }

    @SafeVarargs
    public final ChainBuilder<E> addAllLast(E ... EArray) {
        if (EArray == null) {
            return this;
        }
        for (E e2 : EArray) {
            this.addLast(e2);
        }
        return this;
    }

    public final LinkedList<E> build() {
        return new LinkedList<E>(this.list);
    }
}

