/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.io.IOException;
import java.util.List;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public final class DefaultHttpProcessor
implements HttpProcessor {
    private final HttpRequestInterceptor[] requestInterceptors;
    private final HttpResponseInterceptor[] responseInterceptors;

    public DefaultHttpProcessor(HttpRequestInterceptor[] httpRequestInterceptorArray, HttpResponseInterceptor[] httpResponseInterceptorArray) {
        int n2;
        if (httpRequestInterceptorArray != null) {
            n2 = httpRequestInterceptorArray.length;
            this.requestInterceptors = new HttpRequestInterceptor[n2];
            System.arraycopy(httpRequestInterceptorArray, 0, this.requestInterceptors, 0, n2);
        } else {
            this.requestInterceptors = new HttpRequestInterceptor[0];
        }
        if (httpResponseInterceptorArray != null) {
            n2 = httpResponseInterceptorArray.length;
            this.responseInterceptors = new HttpResponseInterceptor[n2];
            System.arraycopy(httpResponseInterceptorArray, 0, this.responseInterceptors, 0, n2);
            return;
        }
        this.responseInterceptors = new HttpResponseInterceptor[0];
    }

    public DefaultHttpProcessor(List<HttpRequestInterceptor> list, List<HttpResponseInterceptor> list2) {
        int n2;
        if (list != null) {
            n2 = list.size();
            this.requestInterceptors = list.toArray(new HttpRequestInterceptor[n2]);
        } else {
            this.requestInterceptors = new HttpRequestInterceptor[0];
        }
        if (list2 != null) {
            n2 = list2.size();
            this.responseInterceptors = list2.toArray(new HttpResponseInterceptor[n2]);
            return;
        }
        this.responseInterceptors = new HttpResponseInterceptor[0];
    }

    public DefaultHttpProcessor(HttpRequestInterceptor ... httpRequestInterceptorArray) {
        this(httpRequestInterceptorArray, (HttpResponseInterceptor[])null);
    }

    public DefaultHttpProcessor(HttpResponseInterceptor ... httpResponseInterceptorArray) {
        this((HttpRequestInterceptor[])null, httpResponseInterceptorArray);
    }

    @Override
    public final void process(HttpRequest httpRequest, EntityDetails entityDetails, HttpContext httpContext) throws IOException, HttpException {
        HttpRequestInterceptor[] httpRequestInterceptorArray = this.requestInterceptors;
        int n2 = this.requestInterceptors.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            HttpRequestInterceptor httpRequestInterceptor = httpRequestInterceptorArray[i2];
            httpRequestInterceptor.process(httpRequest, entityDetails, httpContext);
        }
    }

    @Override
    public final void process(HttpResponse httpResponse, EntityDetails entityDetails, HttpContext httpContext) throws IOException, HttpException {
        HttpResponseInterceptor[] httpResponseInterceptorArray = this.responseInterceptors;
        int n2 = this.responseInterceptors.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            HttpResponseInterceptor httpResponseInterceptor = httpResponseInterceptorArray[i2];
            httpResponseInterceptor.process(httpResponse, entityDetails, httpContext);
        }
    }
}

