/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ForwardedRequest
implements HttpRequestInterceptor {
    private static final String FORWARDED_HEADER_NAME = "Forwarded";
    public static final HttpRequestInterceptor INSTANCE = new ForwardedRequest();

    @Override
    public void process(HttpRequest httpRequest, EntityDetails object, HttpContext object2) throws HttpException, IOException {
        Args.notNull(httpRequest, "HTTP request");
        Args.notNull(object2, "HTTP context");
        object = HttpCoreContext.cast((HttpContext)object2);
        object2 = ((HttpCoreContext)object).getProtocolVersion() != null ? ((HttpCoreContext)object).getProtocolVersion() : HttpVersion.HTTP_1_1;
        URIAuthority uRIAuthority = httpRequest.getAuthority();
        if (uRIAuthority == null) {
            throw new ProtocolException("Request authority not specified");
        }
        int n2 = uRIAuthority.getPort();
        StringBuilder stringBuilder = new StringBuilder();
        Object object3 = httpRequest.getFirstHeader(FORWARDED_HEADER_NAME);
        boolean bl2 = object3 != null;
        if (bl2) {
            stringBuilder.append(object3.getValue());
            stringBuilder.append(", ");
        }
        if ((object = ((HttpCoreContext)object).getEndpointDetails()) != null) {
            Object object4;
            object3 = ((EndpointDetails)object).getRemoteAddress();
            if (object3 instanceof InetSocketAddress) {
                object3 = (InetSocketAddress)object3;
                object4 = ((InetSocketAddress)object3).getHostString() + ":" + ((InetSocketAddress)object3).getPort();
                if (((InetSocketAddress)object3).getAddress() instanceof Inet6Address) {
                    stringBuilder.append("by=\"").append((String)object4).append("\"");
                } else {
                    stringBuilder.append("by=").append((String)object4);
                }
            }
            if ((object3 = ((EndpointDetails)object).getLocalAddress()) instanceof InetSocketAddress) {
                object4 = (InetSocketAddress)object3;
                object = ((InetSocketAddress)object4).getHostString() + ":" + ((InetSocketAddress)object4).getPort();
                if (((InetSocketAddress)object4).getAddress() instanceof Inet6Address) {
                    stringBuilder.append(";for=\"").append((String)object).append("\"");
                } else {
                    stringBuilder.append(";for=").append((String)object);
                }
            }
        }
        if (stringBuilder.length() > 0 && !bl2) {
            stringBuilder.append(";");
        }
        stringBuilder.append("host=\"").append(uRIAuthority.getHostName()).append("\"");
        if (n2 != -1) {
            stringBuilder.append(";port=").append(n2);
        }
        if ((object3 = ((ProtocolVersion)object2).getProtocol()) != null) {
            stringBuilder.append(";proto=").append((String)object3);
        }
        object3 = stringBuilder.toString();
        httpRequest.setHeader(FORWARDED_HEADER_NAME, object3);
    }
}

