/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;

@Contract(threading=ThreadingBehavior.SAFE)
public class HttpDateGenerator {
    private static final int GRANULARITY_MILLIS = 1000;
    @Deprecated
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String INTERNET_MESSAGE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    @Deprecated
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    public static final ZoneId GMT_ID = ZoneId.of("GMT");
    public static final HttpDateGenerator INSTANCE = new HttpDateGenerator("EEE, dd MMM yyyy HH:mm:ss zzz", GMT_ID);
    private final DateTimeFormatter dateTimeFormatter;
    private long dateAsMillis;
    private String dateAsText;
    private ZoneId zoneId;
    private final ReentrantLock lock;

    private HttpDateGenerator(String string, ZoneId zoneId) {
        this.dateTimeFormatter = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern(string).toFormatter();
        this.zoneId = zoneId;
        this.lock = new ReentrantLock();
    }

    public String getCurrentDate() {
        this.lock.lock();
        try {
            long l2 = System.currentTimeMillis();
            if (l2 - this.dateAsMillis > 1000L) {
                this.dateAsText = this.dateTimeFormatter.format(Instant.now().atZone(this.zoneId));
                this.dateAsMillis = l2;
            }
            String string = this.dateAsText;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }
}

