/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.MisdirectedRequestException;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.LookupRegistry;
import org.apache.hc.core5.http.protocol.UriPatternMatcher;
import org.apache.hc.core5.http.protocol.UriPatternOrderedMatcher;
import org.apache.hc.core5.http.protocol.UriPatternType;
import org.apache.hc.core5.http.protocol.UriRegexMatcher;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;

@Deprecated
@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class RequestHandlerRegistry<T>
implements HttpRequestMapper<T> {
    private static final String LOCALHOST = "localhost";
    private static final String IP_127_0_0_1 = "127.0.0.1";
    private final String canonicalHostName;
    private final Supplier<LookupRegistry<T>> registrySupplier;
    private final LookupRegistry<T> primary;
    private final ConcurrentMap<String, LookupRegistry<T>> virtualMap;

    public RequestHandlerRegistry(String string, Supplier<LookupRegistry<T>> supplier) {
        this.canonicalHostName = TextUtils.toLowerCase(Args.notNull(string, "Canonical hostname"));
        this.registrySupplier = supplier != null ? supplier : UriPatternMatcher::new;
        this.primary = this.registrySupplier.get();
        this.virtualMap = new ConcurrentHashMap<String, LookupRegistry<T>>();
    }

    static <T> LookupRegistry<T> newMatcher(UriPatternType uriPatternType) {
        if (uriPatternType == null) {
            return new UriPatternMatcher();
        }
        switch (uriPatternType) {
            case REGEX: {
                return new UriRegexMatcher();
            }
            case URI_PATTERN_IN_ORDER: {
                return new UriPatternOrderedMatcher();
            }
        }
        return new UriPatternMatcher();
    }

    public RequestHandlerRegistry(String string, UriPatternType uriPatternType) {
        this(string, () -> RequestHandlerRegistry.newMatcher(uriPatternType));
    }

    public RequestHandlerRegistry(UriPatternType uriPatternType) {
        this(LOCALHOST, uriPatternType);
    }

    public RequestHandlerRegistry() {
        this(LOCALHOST, UriPatternType.URI_PATTERN);
    }

    private LookupRegistry<T> getPatternMatcher(String string) {
        if (string == null || string.equals(this.canonicalHostName) || string.equals(LOCALHOST) || string.equals(IP_127_0_0_1)) {
            return this.primary;
        }
        return (LookupRegistry)this.virtualMap.get(string);
    }

    @Override
    public T resolve(HttpRequest object, HttpContext object2) throws MisdirectedRequestException {
        object2 = object.getAuthority();
        object2 = object2 != null ? TextUtils.toLowerCase(((URIAuthority)object2).getHostName()) : null;
        if ((object2 = this.getPatternMatcher((String)object2)) == null) {
            throw new MisdirectedRequestException("Not authoritative");
        }
        int n2 = ((String)(object = object.getPath())).indexOf(63);
        if (n2 != -1) {
            object = ((String)object).substring(0, n2);
        }
        return object2.lookup((String)object);
    }

    public void register(String lookupRegistry, String string, T t2) {
        LookupRegistry<T> lookupRegistry2;
        Args.notBlank(string, "URI pattern");
        if (t2 == null) {
            return;
        }
        String string2 = TextUtils.toLowerCase((String)((Object)lookupRegistry));
        if (lookupRegistry == null || ((String)((Object)lookupRegistry)).equals(this.canonicalHostName) || ((String)((Object)lookupRegistry)).equals(LOCALHOST)) {
            this.primary.register(string, t2);
            return;
        }
        lookupRegistry = (LookupRegistry)this.virtualMap.get(string2);
        if (lookupRegistry == null && (lookupRegistry = this.virtualMap.putIfAbsent(string2, lookupRegistry2 = this.registrySupplier.get())) == null) {
            lookupRegistry = lookupRegistry2;
        }
        lookupRegistry.register(string, t2);
    }
}

