/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    public static final HttpRequestInterceptor INSTANCE = new RequestTargetHost();

    @Override
    public void process(HttpRequest httpRequest, EntityDetails object, HttpContext object2) throws HttpException, IOException {
        Args.notNull(httpRequest, "HTTP request");
        Args.notNull(object2, "HTTP context");
        object = object2.getProtocolVersion();
        object2 = httpRequest.getMethod();
        if (Method.CONNECT.isSame((String)object2) && ((ProtocolVersion)object).lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!httpRequest.containsHeader("Host")) {
            object2 = httpRequest.getAuthority();
            if (object2 == null) {
                if (((ProtocolVersion)object).lessEquals(HttpVersion.HTTP_1_0)) {
                    return;
                }
                throw new ProtocolException("Target host is unknown");
            }
            if (((URIAuthority)object2).getUserInfo() != null) {
                object2 = new URIAuthority(((URIAuthority)object2).getHostName(), ((URIAuthority)object2).getPort());
            }
            httpRequest.addHeader("Host", object2);
        }
    }
}

