/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestValidateHost
implements HttpRequestInterceptor {
    public static final RequestValidateHost INSTANCE = new RequestValidateHost();

    @Override
    public void process(HttpRequest httpRequest, EntityDetails object, HttpContext httpContext) throws HttpException, IOException {
        Args.notNull(httpRequest, "HTTP request");
        if (httpRequest.getAuthority() != null) {
            return;
        }
        object = httpRequest.getHeader("Host");
        if (object != null) {
            try {
                object = URIAuthority.create(object.getValue());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ProtocolException(uRISyntaxException.getMessage(), uRISyntaxException);
            }
            httpRequest.setAuthority((URIAuthority)object);
            return;
        }
        object = httpRequest.getVersion() != null ? httpRequest.getVersion() : HttpVersion.HTTP_1_1;
        if (((ProtocolVersion)object).greaterEquals(HttpVersion.HTTP_1_1)) {
            throw new ProtocolException("Host header is absent");
        }
    }
}

