/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseContent
implements HttpResponseInterceptor {
    public static final ResponseContent INSTANCE = new ResponseContent();
    private final boolean overwrite;

    public ResponseContent() {
        this(false);
    }

    public ResponseContent(boolean bl2) {
        this.overwrite = bl2;
    }

    @Override
    public void process(HttpResponse httpResponse, EntityDetails entityDetails, HttpContext object) throws HttpException, IOException {
        Args.notNull(httpResponse, "HTTP response");
        if (this.overwrite) {
            httpResponse.removeHeaders("Transfer-Encoding");
            httpResponse.removeHeaders("Content-Length");
        } else {
            if (httpResponse.containsHeader("Transfer-Encoding")) {
                throw new ProtocolException("Transfer-encoding header already present");
            }
            if (httpResponse.containsHeader("Content-Length")) {
                throw new ProtocolException("Content-Length header already present");
            }
        }
        object = object.getProtocolVersion();
        if (entityDetails != null) {
            long l2 = entityDetails.getContentLength();
            if (l2 >= 0L && !entityDetails.isChunked()) {
                httpResponse.addHeader("Content-Length", Long.toString(entityDetails.getContentLength()));
            } else if (((ProtocolVersion)object).greaterEquals(HttpVersion.HTTP_1_1)) {
                httpResponse.addHeader("Transfer-Encoding", "chunked");
                MessageSupport.addTrailerHeader(httpResponse, entityDetails);
            }
            MessageSupport.addContentTypeHeader(httpResponse, entityDetails);
            MessageSupport.addContentEncodingHeader(httpResponse, entityDetails);
            return;
        }
        int n2 = httpResponse.getCode();
        if (n2 != 204 && n2 != 304) {
            httpResponse.addHeader("Content-Length", "0");
        }
    }
}

