/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ViaRequest
implements HttpRequestInterceptor {
    public static final HttpRequestInterceptor INSTANCE = new ViaRequest();

    @Override
    public void process(HttpRequest httpRequest, EntityDetails object, HttpContext object2) throws ProtocolException, IOException {
        Args.notNull(httpRequest, "HTTP request");
        Args.notNull(object2, "HTTP context");
        object = object2.getProtocolVersion() != null ? object2.getProtocolVersion() : HttpVersion.HTTP_1_1;
        object2 = httpRequest.getAuthority();
        if (object2 == null) {
            throw new ProtocolException("Request authority not specified");
        }
        if (!((ProtocolVersion)object).greaterEquals(HttpVersion.HTTP_1_1)) {
            throw new ProtocolException("Invalid protocol version: %s", object);
        }
        if (!httpRequest.containsHeader("Via")) {
            object = ((ProtocolVersion)object).getProtocol() + " " + ((ProtocolVersion)object).getMajor() + "." + ((ProtocolVersion)object).getMinor() + " " + ((URIAuthority)object2).getHostName();
            int n2 = ((URIAuthority)object2).getPort();
            if (n2 != -1) {
                object = (String)object + ":" + n2;
            }
            httpRequest.addHeader("Via", object);
        }
    }
}

