/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.ssl;

import java.util.ArrayList;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.ProtocolVersionParser;
import org.apache.hc.core5.util.Tokenizer;
import org.apache.hc.core5.util.Tokenizer$Cursor;
import org.apache.hc.core5.util.Tokenizer$Delimiter;

public enum TLS {
    V_1_0("TLSv1", new ProtocolVersion("TLS", 1, 0)),
    V_1_1("TLSv1.1", new ProtocolVersion("TLS", 1, 1)),
    V_1_2("TLSv1.2", new ProtocolVersion("TLS", 1, 2)),
    V_1_3("TLSv1.3", new ProtocolVersion("TLS", 1, 3));

    public final String id;
    public final ProtocolVersion version;

    private TLS(String string2, ProtocolVersion protocolVersion) {
        this.id = string2;
        this.version = protocolVersion;
    }

    public final boolean isSame(ProtocolVersion protocolVersion) {
        return this.version.equals(protocolVersion);
    }

    public final boolean isComparable(ProtocolVersion protocolVersion) {
        return this.version.isComparable(protocolVersion);
    }

    public final String getId() {
        return this.id;
    }

    public final ProtocolVersion getVersion() {
        return this.version;
    }

    public final boolean greaterEquals(ProtocolVersion protocolVersion) {
        return this.version.greaterEquals(protocolVersion);
    }

    public final boolean lessEquals(ProtocolVersion protocolVersion) {
        return this.version.lessEquals(protocolVersion);
    }

    @Internal
    public static ProtocolVersion parse(CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor, Tokenizer$Delimiter tokenizer$Delimiter) throws ParseException {
        int n2 = tokenizer$Cursor.getLowerBound();
        int n3 = tokenizer$Cursor.getUpperBound();
        int n4 = tokenizer$Cursor.getPos();
        if (n4 + 4 > tokenizer$Cursor.getUpperBound()) {
            throw new ParseException("Invalid TLS protocol version", charSequence, n2, n3, n4);
        }
        if (charSequence.charAt(n4) != 'T' || charSequence.charAt(n4 + 1) != 'L' || charSequence.charAt(n4 + 2) != 'S' || charSequence.charAt(n4 + 3) != 'v') {
            throw new ParseException("Invalid TLS protocol version", charSequence, n2, n3, n4);
        }
        tokenizer$Cursor.updatePos(n4 += 4);
        if (tokenizer$Cursor.atEnd()) {
            throw new ParseException("Invalid TLS version", charSequence, n2, n3, n4);
        }
        return ProtocolVersionParser.INSTANCE.parse("TLS", null, charSequence, tokenizer$Cursor, tokenizer$Delimiter);
    }

    public static ProtocolVersion parse(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        Tokenizer$Cursor tokenizer$Cursor = new Tokenizer$Cursor(0, string.length());
        ProtocolVersion protocolVersion = TLS.parse(string, tokenizer$Cursor, null);
        Tokenizer.INSTANCE.skipWhiteSpace(string, tokenizer$Cursor);
        if (!tokenizer$Cursor.atEnd()) {
            throw new ParseException("Invalid TLS protocol version; trailing content");
        }
        return protocolVersion;
    }

    public static String[] excludeWeak(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (!TLS.isSecure(string)) continue;
            arrayList.add(string);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(TLS.V_1_2.id);
        }
        return arrayList.toArray(new String[0]);
    }

    public static boolean isSecure(String string) {
        return !string.startsWith("SSL") && !string.equals(TLS.V_1_0.id) && !string.equals(TLS.V_1_1.id);
    }
}

