/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.support;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.HeaderGroup;
import org.apache.hc.core5.http.support.AbstractRequestBuilder;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.util.Args;

public class BasicRequestBuilder
extends AbstractRequestBuilder<BasicHttpRequest> {
    BasicRequestBuilder(String string) {
        super(string);
    }

    BasicRequestBuilder(Method method) {
        super(method);
    }

    BasicRequestBuilder(String string, URI uRI) {
        super(string, uRI);
    }

    BasicRequestBuilder(Method method, URI uRI) {
        super(method, uRI);
    }

    BasicRequestBuilder(Method method, String string) {
        super(method, string);
    }

    BasicRequestBuilder(String string, String string2) {
        super(string, string2);
    }

    public static BasicRequestBuilder create(String string) {
        Args.notBlank(string, "HTTP method");
        return new BasicRequestBuilder(string);
    }

    public static BasicRequestBuilder get() {
        return new BasicRequestBuilder(Method.GET);
    }

    public static BasicRequestBuilder get(URI uRI) {
        return new BasicRequestBuilder(Method.GET, uRI);
    }

    public static BasicRequestBuilder get(String string) {
        return new BasicRequestBuilder(Method.GET, string);
    }

    public static BasicRequestBuilder head() {
        return new BasicRequestBuilder(Method.HEAD);
    }

    public static BasicRequestBuilder head(URI uRI) {
        return new BasicRequestBuilder(Method.HEAD, uRI);
    }

    public static BasicRequestBuilder head(String string) {
        return new BasicRequestBuilder(Method.HEAD, string);
    }

    public static BasicRequestBuilder patch() {
        return new BasicRequestBuilder(Method.PATCH);
    }

    public static BasicRequestBuilder patch(URI uRI) {
        return new BasicRequestBuilder(Method.PATCH, uRI);
    }

    public static BasicRequestBuilder patch(String string) {
        return new BasicRequestBuilder(Method.PATCH, string);
    }

    public static BasicRequestBuilder post() {
        return new BasicRequestBuilder(Method.POST);
    }

    public static BasicRequestBuilder post(URI uRI) {
        return new BasicRequestBuilder(Method.POST, uRI);
    }

    public static BasicRequestBuilder post(String string) {
        return new BasicRequestBuilder(Method.POST, string);
    }

    public static BasicRequestBuilder put() {
        return new BasicRequestBuilder(Method.PUT);
    }

    public static BasicRequestBuilder put(URI uRI) {
        return new BasicRequestBuilder(Method.PUT, uRI);
    }

    public static BasicRequestBuilder put(String string) {
        return new BasicRequestBuilder(Method.PUT, string);
    }

    public static BasicRequestBuilder delete() {
        return new BasicRequestBuilder(Method.DELETE);
    }

    public static BasicRequestBuilder delete(URI uRI) {
        return new BasicRequestBuilder(Method.DELETE, uRI);
    }

    public static BasicRequestBuilder delete(String string) {
        return new BasicRequestBuilder(Method.DELETE, string);
    }

    public static BasicRequestBuilder trace() {
        return new BasicRequestBuilder(Method.TRACE);
    }

    public static BasicRequestBuilder trace(URI uRI) {
        return new BasicRequestBuilder(Method.TRACE, uRI);
    }

    public static BasicRequestBuilder trace(String string) {
        return new BasicRequestBuilder(Method.TRACE, string);
    }

    public static BasicRequestBuilder options() {
        return new BasicRequestBuilder(Method.OPTIONS);
    }

    public static BasicRequestBuilder options(URI uRI) {
        return new BasicRequestBuilder(Method.OPTIONS, uRI);
    }

    public static BasicRequestBuilder options(String string) {
        return new BasicRequestBuilder(Method.OPTIONS, string);
    }

    public static BasicRequestBuilder copy(HttpRequest httpRequest) {
        Args.notNull(httpRequest, "HTTP request");
        BasicRequestBuilder basicRequestBuilder = new BasicRequestBuilder(httpRequest.getMethod());
        basicRequestBuilder.digest(httpRequest);
        return basicRequestBuilder;
    }

    @Override
    public BasicRequestBuilder setVersion(ProtocolVersion protocolVersion) {
        super.setVersion(protocolVersion);
        return this;
    }

    public BasicRequestBuilder setUri(URI uRI) {
        super.setUri(uRI);
        return this;
    }

    public BasicRequestBuilder setUri(String string) {
        super.setUri(string);
        return this;
    }

    public BasicRequestBuilder setScheme(String string) {
        super.setScheme(string);
        return this;
    }

    public BasicRequestBuilder setAuthority(URIAuthority uRIAuthority) {
        super.setAuthority(uRIAuthority);
        return this;
    }

    public BasicRequestBuilder setHttpHost(HttpHost httpHost) {
        super.setHttpHost(httpHost);
        return this;
    }

    public BasicRequestBuilder setPath(String string) {
        super.setPath(string);
        return this;
    }

    @Override
    public BasicRequestBuilder setHeaders(Header ... headerArray) {
        super.setHeaders(headerArray);
        return this;
    }

    @Override
    public BasicRequestBuilder addHeader(Header header) {
        super.addHeader(header);
        return this;
    }

    @Override
    public BasicRequestBuilder addHeader(String string, String string2) {
        super.addHeader(string, string2);
        return this;
    }

    @Override
    public BasicRequestBuilder removeHeader(Header header) {
        super.removeHeader(header);
        return this;
    }

    @Override
    public BasicRequestBuilder removeHeaders(String string) {
        super.removeHeaders(string);
        return this;
    }

    @Override
    public BasicRequestBuilder setHeader(Header header) {
        super.setHeader(header);
        return this;
    }

    @Override
    public BasicRequestBuilder setHeader(String string, String string2) {
        super.setHeader(string, string2);
        return this;
    }

    public BasicRequestBuilder setCharset(Charset charset) {
        super.setCharset(charset);
        return this;
    }

    public BasicRequestBuilder addParameter(NameValuePair nameValuePair) {
        super.addParameter(nameValuePair);
        return this;
    }

    public BasicRequestBuilder addParameter(String string, String string2) {
        super.addParameter(string, string2);
        return this;
    }

    public BasicRequestBuilder addParameters(NameValuePair ... nameValuePairArray) {
        super.addParameters(nameValuePairArray);
        return this;
    }

    public BasicRequestBuilder setAbsoluteRequestUri(boolean bl2) {
        super.setAbsoluteRequestUri(bl2);
        return this;
    }

    @Override
    public BasicHttpRequest build() {
        String string = this.getPath();
        List<NameValuePair> list = this.getParameters();
        if (list != null && !list.isEmpty()) {
            try {
                list = new URIBuilder(string).setCharset(this.getCharset()).addParameters(list).build();
                string = ((URI)((Object)list)).toASCIIString();
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        list = new BasicHttpRequest(this.getMethod(), this.getScheme(), this.getAuthority(), string);
        ((BasicHttpRequest)((Object)list)).setVersion(this.getVersion());
        ((HeaderGroup)((Object)list)).setHeaders(this.getHeaders());
        ((BasicHttpRequest)((Object)list)).setAbsoluteRequestUri(this.isAbsoluteRequestUri());
        return list;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BasicRequestBuilder [method=");
        stringBuilder.append(this.getMethod());
        stringBuilder.append(", scheme=");
        stringBuilder.append(this.getScheme());
        stringBuilder.append(", authority=");
        stringBuilder.append(this.getAuthority());
        stringBuilder.append(", path=");
        stringBuilder.append(this.getPath());
        stringBuilder.append(", parameters=");
        stringBuilder.append(this.getParameters());
        stringBuilder.append(", headerGroup=");
        stringBuilder.append(Arrays.toString(this.getHeaders()));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

