/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.config;

public enum H2Param {
    HEADER_TABLE_SIZE(1),
    ENABLE_PUSH(2),
    MAX_CONCURRENT_STREAMS(3),
    INITIAL_WINDOW_SIZE(4),
    MAX_FRAME_SIZE(5),
    MAX_HEADER_LIST_SIZE(6);

    int code;
    private static final H2Param[] LOOKUP_TABLE;

    private H2Param(int n3) {
        this.code = n3;
    }

    public final int getCode() {
        return this.code;
    }

    public static H2Param valueOf(int n2) {
        if (n2 <= 0 || n2 > LOOKUP_TABLE.length) {
            return null;
        }
        return LOOKUP_TABLE[n2 - 1];
    }

    public static String toString(int n2) {
        if (n2 <= 0 || n2 > LOOKUP_TABLE.length) {
            return Integer.toString(n2);
        }
        return LOOKUP_TABLE[n2 - 1].name();
    }

    static {
        LOOKUP_TABLE = new H2Param[6];
        H2Param[] h2ParamArray = H2Param.values();
        int n2 = h2ParamArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            H2Param h2Param;
            H2Param.LOOKUP_TABLE[h2Param.code - 1] = h2Param = h2ParamArray[i2];
        }
    }
}

