/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.frame;

import org.apache.hc.core5.http2.frame.FrameFlag;
import org.apache.hc.core5.http2.frame.FrameType;

public abstract class Frame<T> {
    private final int type;
    private final int flags;
    private final int streamId;

    public Frame(int n2, int n3, int n4) {
        this.type = n2;
        this.flags = n3;
        this.streamId = n4;
    }

    public boolean isType(FrameType frameType) {
        return this.getType() == frameType.value;
    }

    public boolean isFlagSet(FrameFlag frameFlag) {
        return (this.getFlags() & frameFlag.value) != 0;
    }

    public int getType() {
        return this.type;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public abstract T getPayload();

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        stringBuilder.append("type=").append(this.type);
        stringBuilder.append(", flags=").append(this.flags);
        stringBuilder.append(", streamId=").append(this.streamId);
        stringBuilder.append(", payoad=").append(this.getPayload());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

