/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.frame;

public enum FrameType {
    DATA(0),
    HEADERS(1),
    PRIORITY(2),
    RST_STREAM(3),
    SETTINGS(4),
    PUSH_PROMISE(5),
    PING(6),
    GOAWAY(7),
    WINDOW_UPDATE(8),
    CONTINUATION(9);

    int value;
    private static final FrameType[] LOOKUP_TABLE;

    private FrameType(int n3) {
        this.value = n3;
    }

    public final int getValue() {
        return this.value;
    }

    public static FrameType valueOf(int n2) {
        if (n2 < 0 || n2 >= LOOKUP_TABLE.length) {
            return null;
        }
        return LOOKUP_TABLE[n2];
    }

    public static String toString(int n2) {
        if (n2 < 0 || n2 >= LOOKUP_TABLE.length) {
            return Integer.toString(n2);
        }
        return LOOKUP_TABLE[n2].name();
    }

    static {
        LOOKUP_TABLE = new FrameType[10];
        FrameType[] frameTypeArray = FrameType.values();
        int n2 = frameTypeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            FrameType frameType;
            FrameType.LOOKUP_TABLE[frameType.value] = frameType = frameTypeArray[i2];
        }
    }
}

