/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.frame;

import java.nio.ByteBuffer;
import org.apache.hc.core5.http2.frame.Frame;
import org.apache.hc.core5.http2.frame.FrameFlag;

public final class RawFrame
extends Frame<ByteBuffer> {
    private final ByteBuffer payload;
    private final int len;

    public RawFrame(int n2, int n3, int n4, ByteBuffer byteBuffer) {
        super(n2, n3, n4);
        this.payload = byteBuffer;
        this.len = byteBuffer != null ? byteBuffer.remaining() : 0;
    }

    public final boolean isPadded() {
        return this.isFlagSet(FrameFlag.PADDED);
    }

    public final int getLength() {
        return this.len;
    }

    public final ByteBuffer getPayloadContent() {
        if (this.payload != null) {
            if (this.isPadded()) {
                ByteBuffer byteBuffer = this.payload.duplicate();
                if (byteBuffer.remaining() == 0) {
                    return null;
                }
                int n2 = byteBuffer.get() & 0xFF;
                if (n2 > byteBuffer.remaining()) {
                    return null;
                }
                ByteBuffer byteBuffer2 = byteBuffer;
                byteBuffer2.limit(byteBuffer2.limit() - n2);
                return byteBuffer;
            }
            return this.payload.duplicate();
        }
        return null;
    }

    @Override
    public final ByteBuffer getPayload() {
        if (this.payload != null) {
            return this.payload.duplicate();
        }
        return null;
    }
}

