/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.hpack;

import org.apache.hc.core5.http2.hpack.HPackHeader;

final class FifoBuffer {
    private HPackHeader[] array;
    private int head;
    private int tail;

    FifoBuffer(int n2) {
        this.array = new HPackHeader[n2];
        this.head = 0;
        this.tail = 0;
    }

    private void expand() {
        int n2 = this.array.length + 1 << 1;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        HPackHeader[] hPackHeaderArray = this.array;
        int n3 = this.array.length;
        HPackHeader[] hPackHeaderArray2 = new HPackHeader[n2];
        System.arraycopy(hPackHeaderArray, this.head, hPackHeaderArray2, 0, n3 - this.head);
        System.arraycopy(hPackHeaderArray, 0, hPackHeaderArray2, n3 - this.head, this.head);
        this.array = hPackHeaderArray2;
        this.head = n3;
        this.tail = 0;
    }

    public final void clear() {
        this.head = 0;
        this.tail = 0;
    }

    public final void addFirst(HPackHeader hPackHeader) {
        this.array[this.head++] = hPackHeader;
        if (this.head == this.array.length) {
            this.head = 0;
        }
        if (this.head == this.tail) {
            this.expand();
        }
    }

    public final HPackHeader get(int n2) {
        if ((n2 = this.head - n2 - 1) < 0) {
            n2 = this.array.length + n2;
        }
        return this.array[n2];
    }

    public final HPackHeader getFirst() {
        return this.array[this.head > 0 ? this.head - 1 : this.array.length - 1];
    }

    public final HPackHeader getLast() {
        return this.array[this.tail];
    }

    public final HPackHeader removeLast() {
        HPackHeader hPackHeader = this.array[this.tail];
        if (hPackHeader != null) {
            this.array[this.tail++] = null;
            if (this.tail == this.array.length) {
                this.tail = 0;
            }
        }
        return hPackHeader;
    }

    public final int capacity() {
        return this.array.length;
    }

    public final int size() {
        int n2 = this.head - this.tail;
        if (n2 < 0) {
            n2 = this.array.length + n2;
        }
        return n2;
    }
}

