/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.hpack;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http2.hpack.HPackEntry;
import org.apache.hc.core5.http2.hpack.HPackHeader;
import org.apache.hc.core5.http2.hpack.HPackRepresentation;
import org.apache.hc.core5.http2.hpack.Huffman;
import org.apache.hc.core5.http2.hpack.OutboundDynamicTable;
import org.apache.hc.core5.http2.hpack.StaticTable;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.ByteArrayBuffer;

@Internal
public final class HPackEncoder {
    private final OutboundDynamicTable dynamicTable;
    private final ByteArrayBuffer huffmanBuf;
    private final CharsetEncoder charsetEncoder;
    private ByteBuffer tmpBuf;
    private int maxTableSize;

    HPackEncoder(OutboundDynamicTable outboundDynamicTable, CharsetEncoder charsetEncoder) {
        this.dynamicTable = Objects.requireNonNull(outboundDynamicTable);
        this.huffmanBuf = new ByteArrayBuffer(128);
        this.charsetEncoder = charsetEncoder;
        this.maxTableSize = this.dynamicTable.getMaxSize();
    }

    HPackEncoder(OutboundDynamicTable outboundDynamicTable, Charset charset) {
        this(outboundDynamicTable, charset != null && !StandardCharsets.US_ASCII.equals(charset) ? charset.newEncoder() : null);
    }

    public HPackEncoder(int n2, Charset charset) {
        this(new OutboundDynamicTable(n2), charset);
    }

    public HPackEncoder(int n2, CharsetEncoder charsetEncoder) {
        this(new OutboundDynamicTable(n2), charsetEncoder);
    }

    static void encodeInt(ByteArrayBuffer byteArrayBuffer, int n2, int n3, int n4) {
        int n5 = n3;
        if (n5 < (n2 = 255 >>> 8 - n2)) {
            byteArrayBuffer.append(n3 | n4);
            return;
        }
        byteArrayBuffer.append(n2 | n4);
        n5 -= n2;
        while (n5 >= 128) {
            byteArrayBuffer.append(n5 & 0x7F | 0x80);
            n5 >>>= 7;
        }
        byteArrayBuffer.append(n5);
    }

    static void encodeHuffman(ByteArrayBuffer byteArrayBuffer, ByteBuffer byteBuffer) {
        Huffman.ENCODER.encode(byteArrayBuffer, byteBuffer);
    }

    final void encodeString(ByteArrayBuffer byteArrayBuffer, ByteBuffer byteBuffer, boolean bl2) {
        int n2 = byteBuffer.remaining();
        if (bl2) {
            this.huffmanBuf.clear();
            this.huffmanBuf.ensureCapacity(n2);
            Huffman.ENCODER.encode(this.huffmanBuf, byteBuffer);
            byteArrayBuffer.ensureCapacity(this.huffmanBuf.length() + 8);
            HPackEncoder.encodeInt(byteArrayBuffer, 7, this.huffmanBuf.length(), 128);
            byteArrayBuffer.append(this.huffmanBuf.array(), 0, this.huffmanBuf.length());
            return;
        }
        byteArrayBuffer.ensureCapacity(n2 + 8);
        HPackEncoder.encodeInt(byteArrayBuffer, 7, n2, 0);
        byteArrayBuffer.append(byteBuffer);
    }

    private void clearState() {
        if (this.tmpBuf != null) {
            this.tmpBuf.clear();
        }
        if (this.charsetEncoder != null) {
            this.charsetEncoder.reset();
        }
    }

    private void expandCapacity(int n2) {
        ByteBuffer byteBuffer = this.tmpBuf;
        this.tmpBuf = ByteBuffer.allocate(n2);
        byteBuffer.flip();
        this.tmpBuf.put(byteBuffer);
    }

    private void ensureCapacity(int n2) {
        if (this.tmpBuf == null) {
            this.tmpBuf = ByteBuffer.allocate(Math.max(256, n2));
        }
        if ((n2 = this.tmpBuf.remaining() + n2) > this.tmpBuf.capacity()) {
            this.expandCapacity(n2);
        }
    }

    final int encodeString(ByteArrayBuffer byteArrayBuffer, CharSequence object, int n2, int n3, boolean bl2) throws CharacterCodingException {
        this.clearState();
        if (this.charsetEncoder == null) {
            if (bl2) {
                this.huffmanBuf.clear();
                this.huffmanBuf.ensureCapacity(n3);
                Huffman.ENCODER.encode(this.huffmanBuf, (CharSequence)object, n2, n3);
                byteArrayBuffer.ensureCapacity(this.huffmanBuf.length() + 8);
                HPackEncoder.encodeInt(byteArrayBuffer, 7, this.huffmanBuf.length(), 128);
                byteArrayBuffer.append(this.huffmanBuf.array(), 0, this.huffmanBuf.length());
            } else {
                byteArrayBuffer.ensureCapacity(n3 + 8);
                HPackEncoder.encodeInt(byteArrayBuffer, 7, n3, 0);
                for (int i2 = 0; i2 < n3; ++i2) {
                    byteArrayBuffer.append(object.charAt(n2 + i2));
                }
            }
            return n3;
        }
        if (object.length() > 0) {
            CharBuffer charBuffer = CharBuffer.wrap((CharSequence)object, n2, n3);
            while (charBuffer.hasRemaining()) {
                this.ensureCapacity((int)((float)charBuffer.remaining() * this.charsetEncoder.averageBytesPerChar()) + 8);
                object = this.charsetEncoder.encode(charBuffer, this.tmpBuf, true);
                if (!((CoderResult)object).isError()) continue;
                ((CoderResult)object).throwException();
            }
            this.ensureCapacity(8);
            object = this.charsetEncoder.flush(this.tmpBuf);
            if (((CoderResult)object).isError()) {
                ((CoderResult)object).throwException();
            }
        }
        this.tmpBuf.flip();
        int n4 = this.tmpBuf.remaining();
        this.encodeString(byteArrayBuffer, this.tmpBuf, bl2);
        return n4;
    }

    final int encodeString(ByteArrayBuffer byteArrayBuffer, String string, boolean bl2) throws CharacterCodingException {
        return this.encodeString(byteArrayBuffer, string, 0, string.length(), bl2);
    }

    final void encodeLiteralHeader(ByteArrayBuffer byteArrayBuffer, HPackEntry hPackEntry, Header header, HPackRepresentation hPackRepresentation, boolean bl2) throws CharacterCodingException {
        this.encodeLiteralHeader(byteArrayBuffer, hPackEntry, header.getName(), header.getValue(), header.isSensitive(), hPackRepresentation, bl2);
    }

    final void encodeLiteralHeader(ByteArrayBuffer byteArrayBuffer, HPackEntry hPackEntry, String string, String string2, boolean bl2, HPackRepresentation hPackRepresentation, boolean bl3) throws CharacterCodingException {
        int n2;
        int n3;
        int n4;
        int n5;
        switch (hPackRepresentation) {
            case WITH_INDEXING: {
                n5 = 64;
                n4 = 6;
                break;
            }
            case WITHOUT_INDEXING: {
                n5 = 0;
                n4 = 4;
                break;
            }
            case NEVER_INDEXED: {
                n5 = 16;
                n4 = 4;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)hPackRepresentation));
            }
        }
        if ((n3 = hPackEntry != null ? hPackEntry.getIndex() : 0) <= 0) {
            HPackEncoder.encodeInt(byteArrayBuffer, n4, 0, n5);
            n2 = this.encodeString(byteArrayBuffer, string, bl3);
        } else {
            HPackEncoder.encodeInt(byteArrayBuffer, n4, n3, n5);
            n2 = hPackEntry.getHeader().getNameLen();
        }
        int n6 = this.encodeString(byteArrayBuffer, string2 != null ? string2 : "", bl3);
        if (hPackRepresentation == HPackRepresentation.WITH_INDEXING) {
            this.dynamicTable.add(new HPackHeader(string, n2, string2, n6, bl2));
        }
    }

    final void encodeIndex(ByteArrayBuffer byteArrayBuffer, int n2) {
        HPackEncoder.encodeInt(byteArrayBuffer, 7, n2, 128);
    }

    private int findFullMatch(List<HPackEntry> list, String string) {
        if (list == null || list.isEmpty()) {
            return 0;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            HPackEntry hPackEntry = list.get(i2);
            if (!Objects.equals(string, hPackEntry.getHeader().getValue())) continue;
            return hPackEntry.getIndex();
        }
        return 0;
    }

    final void encodeHeader(ByteArrayBuffer byteArrayBuffer, Header header, boolean bl2, boolean bl3) throws CharacterCodingException {
        this.encodeHeader(byteArrayBuffer, header.getName(), header.getValue(), header.isSensitive(), bl2, bl3);
    }

    final void encodeHeader(ByteArrayBuffer byteArrayBuffer, String string, String string2, boolean bl2, boolean bl3, boolean bl4) throws CharacterCodingException {
        List<HPackEntry> list;
        if (this.maxTableSize != this.dynamicTable.getMaxSize()) {
            HPackEncoder.encodeInt(byteArrayBuffer, 5, this.maxTableSize, 32);
            this.dynamicTable.setMaxSize(this.maxTableSize);
        }
        HPackRepresentation hPackRepresentation = bl2 ? HPackRepresentation.NEVER_INDEXED : (bl3 ? HPackRepresentation.WITHOUT_INDEXING : HPackRepresentation.WITH_INDEXING);
        List<HPackEntry> list2 = StaticTable.INSTANCE.getByName(string);
        if (hPackRepresentation == HPackRepresentation.WITH_INDEXING) {
            int n2 = this.findFullMatch(list2, string2);
            if (n2 > 0) {
                this.encodeIndex(byteArrayBuffer, n2);
                return;
            }
            list = this.dynamicTable.getByName(string);
            n2 = this.findFullMatch(list, string2);
            if (n2 > 0) {
                this.encodeIndex(byteArrayBuffer, n2);
                return;
            }
        }
        HPackEntry hPackEntry = null;
        if (list2 != null && !list2.isEmpty()) {
            hPackEntry = list2.get(0);
        } else {
            list = this.dynamicTable.getByName(string);
            if (list != null && !list.isEmpty()) {
                hPackEntry = list.get(0);
            }
        }
        this.encodeLiteralHeader(byteArrayBuffer, hPackEntry, string, string2, bl2, hPackRepresentation, bl4);
    }

    final void encodeHeaders(ByteArrayBuffer byteArrayBuffer, List<? extends Header> list, boolean bl2, boolean bl3) throws CharacterCodingException {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.encodeHeader(byteArrayBuffer, list.get(i2), bl2, bl3);
        }
    }

    public final void encodeHeader(ByteArrayBuffer byteArrayBuffer, Header header) throws CharacterCodingException {
        Args.notNull(byteArrayBuffer, "ByteArrayBuffer");
        Args.notNull(header, "Header");
        this.encodeHeader(byteArrayBuffer, header.getName(), header.getValue(), header.isSensitive());
    }

    public final void encodeHeader(ByteArrayBuffer byteArrayBuffer, String string, String string2, boolean bl2) throws CharacterCodingException {
        Args.notNull(byteArrayBuffer, "ByteArrayBuffer");
        Args.notEmpty(string, "Header name");
        this.encodeHeader(byteArrayBuffer, string, string2, bl2, false, true);
    }

    public final void encodeHeaders(ByteArrayBuffer byteArrayBuffer, List<? extends Header> list, boolean bl2) throws CharacterCodingException {
        Args.notNull(byteArrayBuffer, "ByteArrayBuffer");
        Args.notEmpty(list, "Header list");
        this.encodeHeaders(byteArrayBuffer, list, false, bl2);
    }

    public final int getMaxTableSize() {
        return this.maxTableSize;
    }

    public final void setMaxTableSize(int n2) {
        Args.notNegative(n2, "Max table size");
        this.maxTableSize = n2;
    }
}

