/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.hpack;

import java.util.Arrays;
import org.apache.hc.core5.util.Asserts;

final class HuffmanNode {
    private final int symbol;
    private final int bits;
    private final HuffmanNode[] children;

    HuffmanNode() {
        this.symbol = 0;
        this.bits = 8;
        this.children = new HuffmanNode[256];
    }

    HuffmanNode(int n2, int n3) {
        this.symbol = n2;
        this.bits = n3;
        this.children = null;
    }

    public final int getBits() {
        return this.bits;
    }

    public final int getSymbol() {
        return this.symbol;
    }

    public final boolean hasChild(int n2) {
        return this.children != null && this.children[n2] != null;
    }

    public final HuffmanNode getChild(int n2) {
        if (this.children != null) {
            return this.children[n2];
        }
        return null;
    }

    final void setChild(int n2, HuffmanNode huffmanNode) {
        Asserts.notNull(this.children, "Children nodes");
        this.children[n2] = huffmanNode;
    }

    public final boolean isTerminal() {
        return this.children == null;
    }

    public final String toString() {
        return "[symbol=" + this.symbol + ", bits=" + this.bits + ", children=" + Arrays.toString(this.children) + ']';
    }
}

