/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.hpack;

import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http2.hpack.FifoBuffer;
import org.apache.hc.core5.http2.hpack.HPackHeader;
import org.apache.hc.core5.http2.hpack.StaticTable;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;

final class InboundDynamicTable {
    private final StaticTable staticTable;
    private final FifoBuffer headers;
    private int maxSize;
    private int currentSize;

    InboundDynamicTable(int n2, StaticTable staticTable) {
        this.staticTable = staticTable;
        this.headers = new FifoBuffer(256);
        this.maxSize = n2;
        this.currentSize = 0;
    }

    InboundDynamicTable(int n2) {
        this(n2, StaticTable.INSTANCE);
    }

    InboundDynamicTable() {
        this(Integer.MAX_VALUE);
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    public final void setMaxSize(int n2) {
        this.maxSize = n2;
        this.evict();
    }

    public final int getCurrentSize() {
        return this.currentSize;
    }

    final int staticLength() {
        return this.staticTable.length();
    }

    final int dynamicLength() {
        return this.headers.size();
    }

    final Header getDynamicEntry(int n2) {
        return this.headers.get(n2);
    }

    public final int length() {
        return this.staticTable.length() + this.headers.size();
    }

    public final HPackHeader getHeader(int n2) {
        int n3 = this.length();
        Args.check(n2 > 0, "index %s cannot be less than 1", (Object)n2);
        Args.check(n2 <= n3, "length %s cannot be greater than index %s", n3, n2);
        if (n2 <= this.staticTable.length()) {
            return this.staticTable.get(n2);
        }
        return this.headers.get(n2 - this.staticTable.length() - 1);
    }

    public final void add(HPackHeader hPackHeader) {
        int n2 = hPackHeader.getTotalSize();
        if (n2 > this.maxSize) {
            this.clear();
            return;
        }
        this.headers.addFirst(hPackHeader);
        this.currentSize += n2;
        this.evict();
    }

    private void clear() {
        this.currentSize = 0;
        this.headers.clear();
    }

    private void evict() {
        while (this.currentSize > this.maxSize) {
            HPackHeader hPackHeader = this.headers.removeLast();
            if (hPackHeader != null) {
                this.currentSize -= hPackHeader.getTotalSize();
                continue;
            }
            Asserts.check(this.currentSize == 0, "Current table size must be zero");
            return;
        }
    }
}

