/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.hpack;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http2.hpack.FifoLinkedList;
import org.apache.hc.core5.http2.hpack.FifoLinkedList$InternalNode;
import org.apache.hc.core5.http2.hpack.HPackEntry;
import org.apache.hc.core5.http2.hpack.HPackHeader;
import org.apache.hc.core5.http2.hpack.StaticTable;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;

final class OutboundDynamicTable {
    private final StaticTable staticTable;
    private final FifoLinkedList headers;
    private final Map<String, LinkedList<HPackEntry>> mapByName;
    private int maxSize;
    private int currentSize;

    OutboundDynamicTable(int n2, StaticTable staticTable) {
        this.staticTable = staticTable;
        this.headers = new FifoLinkedList();
        this.mapByName = new HashMap<String, LinkedList<HPackEntry>>();
        this.maxSize = n2;
        this.currentSize = 0;
    }

    OutboundDynamicTable(int n2) {
        this(n2, StaticTable.INSTANCE);
    }

    OutboundDynamicTable() {
        this(Integer.MAX_VALUE);
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    public final void setMaxSize(int n2) {
        this.maxSize = n2;
        this.evict();
    }

    public final int getCurrentSize() {
        return this.currentSize;
    }

    final int staticLength() {
        return this.staticTable.length();
    }

    final int dynamicLength() {
        return this.headers.size();
    }

    final Header getDynamicEntry(int n2) {
        return this.headers.get(n2);
    }

    public final int length() {
        return this.staticTable.length() + this.headers.size();
    }

    public final Header getHeader(int n2) {
        int n3 = this.length();
        Args.check(n2 > 0, "index %s cannot be less then 1", (Object)n2);
        Args.check(n2 <= n3, "index %s cannot be greater then length %s ", n2, n3);
        if (n2 <= this.staticTable.length()) {
            return this.staticTable.get(n2);
        }
        return this.headers.get(n2 - this.staticTable.length() - 1);
    }

    public final void add(HPackHeader object) {
        int n2 = ((HPackHeader)object).getTotalSize();
        if (n2 > this.maxSize) {
            this.clear();
            this.mapByName.clear();
            return;
        }
        Object object2 = ((HPackHeader)object).getName();
        object = this.headers.addFirst((HPackHeader)object);
        object2 = this.mapByName.computeIfAbsent((String)object2, string -> new LinkedList());
        ((LinkedList)object2).addFirst(object);
        this.currentSize += n2;
        this.evict();
    }

    private void clear() {
        this.currentSize = 0;
        this.headers.clear();
    }

    public final List<HPackEntry> getByName(String string) {
        return this.mapByName.get(string);
    }

    private void evict() {
        while (this.currentSize > this.maxSize) {
            FifoLinkedList$InternalNode fifoLinkedList$InternalNode = this.headers.removeLast();
            if (fifoLinkedList$InternalNode != null) {
                LinkedList<HPackEntry> linkedList = fifoLinkedList$InternalNode.getHeader();
                this.currentSize -= ((HPackHeader)((Object)linkedList)).getTotalSize();
                linkedList = ((HPackHeader)((Object)linkedList)).getName();
                if ((linkedList = this.mapByName.get(linkedList)) == null) continue;
                linkedList.remove(fifoLinkedList$InternalNode);
                continue;
            }
            Asserts.check(this.currentSize == 0, "Current table size must be zero");
            return;
        }
    }
}

