/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http2.H2MessageConverter;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.TextUtils;

public final class DefaultH2RequestConverter
implements H2MessageConverter<HttpRequest> {
    public static final DefaultH2RequestConverter INSTANCE = new DefaultH2RequestConverter();

    @Override
    public final HttpRequest convert(List<Header> list) throws HttpException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        ArrayList<Header> arrayList = new ArrayList<Header>();
        block14: for (int i2 = 0; i2 < list.size(); ++i2) {
            Header header = list.get(i2);
            String string5 = header.getName();
            String string6 = header.getValue();
            for (int i3 = 0; i3 < string5.length(); ++i3) {
                int n2 = string5.charAt(i3);
                if (!Character.isAlphabetic(n2) || Character.isLowerCase((char)n2)) continue;
                throw new ProtocolException("Header name '%s' is invalid (header name contains uppercase characters)", string5);
            }
            if (string5.startsWith(":")) {
                if (!arrayList.isEmpty()) {
                    throw new ProtocolException("Invalid sequence of headers (pseudo-headers must precede message headers)");
                }
                switch (string5) {
                    case ":method": {
                        if (string != null) {
                            throw new ProtocolException("Multiple '%s' request headers are illegal", string5);
                        }
                        string = string6;
                        continue block14;
                    }
                    case ":scheme": {
                        if (string2 != null) {
                            throw new ProtocolException("Multiple '%s' request headers are illegal", string5);
                        }
                        string2 = string6;
                        continue block14;
                    }
                    case ":path": {
                        if (string4 != null) {
                            throw new ProtocolException("Multiple '%s' request headers are illegal", string5);
                        }
                        string4 = string6;
                        continue block14;
                    }
                    case ":authority": {
                        string3 = string6;
                        continue block14;
                    }
                    default: {
                        throw new ProtocolException("Unsupported request header '%s'", string5);
                    }
                }
            }
            arrayList.add(header);
        }
        if (string == null) {
            throw new ProtocolException("Mandatory request header '%s' not found", ":method");
        }
        if (Method.CONNECT.isSame(string)) {
            if (string3 == null) {
                throw new ProtocolException("Header '%s' is mandatory for CONNECT request", ":authority");
            }
            if (string2 != null) {
                throw new ProtocolException("Header '%s' must not be set for CONNECT request", ":scheme");
            }
            if (string4 != null) {
                throw new ProtocolException("Header '%s' must not be set for CONNECT request", ":path");
            }
        } else {
            if (string2 == null) {
                throw new ProtocolException("Mandatory request header '%s' not found", ":scheme");
            }
            if (string4 == null) {
                throw new ProtocolException("Mandatory request header '%s' not found", ":path");
            }
            this.validatePathPseudoHeader(string, string2, string4);
        }
        BasicHttpRequest basicHttpRequest = new BasicHttpRequest(string, string4);
        basicHttpRequest.setVersion(HttpVersion.HTTP_2);
        basicHttpRequest.setScheme(string2);
        try {
            basicHttpRequest.setAuthority(URIAuthority.create(string3));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ProtocolException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
        basicHttpRequest.setPath(string4);
        for (int i4 = 0; i4 < arrayList.size(); ++i4) {
            basicHttpRequest.addHeader((Header)arrayList.get(i4));
        }
        return basicHttpRequest;
    }

    @Override
    public final List<Header> convert(HttpRequest object) throws HttpException {
        if (TextUtils.isBlank(object.getMethod())) {
            throw new ProtocolException("Request method is empty");
        }
        boolean bl2 = Method.CONNECT.name().equalsIgnoreCase(object.getMethod());
        if (bl2) {
            if (object.getAuthority() == null) {
                throw new ProtocolException("CONNECT request authority is not set");
            }
            if (object.getPath() != null) {
                throw new ProtocolException("CONNECT request path must be null");
            }
        } else {
            if (TextUtils.isBlank(object.getScheme())) {
                throw new ProtocolException("Request scheme is not set");
            }
            if (TextUtils.isBlank(object.getPath())) {
                throw new ProtocolException("Request path is not set");
            }
        }
        ArrayList<Header> arrayList = new ArrayList<Header>();
        arrayList.add(new BasicHeader(":method", object.getMethod(), false));
        if (bl2) {
            arrayList.add(new BasicHeader(":authority", object.getAuthority(), false));
        } else {
            arrayList.add(new BasicHeader(":scheme", object.getScheme(), false));
            if (object.getAuthority() != null) {
                arrayList.add(new BasicHeader(":authority", object.getAuthority(), false));
            }
            arrayList.add(new BasicHeader(":path", object.getPath(), false));
        }
        object = object.headerIterator();
        while (object.hasNext()) {
            Object object2 = (Header)object.next();
            String string = object2.getName();
            object2 = object2.getValue();
            if (string.startsWith(":")) {
                throw new ProtocolException("Header name '%s' is invalid", string);
            }
            arrayList.add(new BasicHeader(TextUtils.toLowerCase(string), object2));
        }
        return arrayList;
    }

    private void validatePathPseudoHeader(String string, String string2, String string3) throws ProtocolException {
        if (URIScheme.HTTP.name().equalsIgnoreCase(string2) || URIScheme.HTTPS.name().equalsIgnoreCase(string2)) {
            if (TextUtils.isBlank(string3)) {
                throw new ProtocolException("':path' pseudo-header field must not be empty for 'http' or 'https' URIs");
            }
            boolean bl2 = string3.startsWith("/");
            if (Method.OPTIONS.isSame(string)) {
                if (!"*".equals(string3) && !bl2) {
                    throw new ProtocolException("OPTIONS request for an 'http' or 'https' URI must have a ':path' pseudo-header field with a value of '*' or '/'");
                }
            } else if (!bl2) {
                throw new ProtocolException("':path' pseudo-header field for 'http' or 'https' URIs must start with '/'");
            }
        }
    }
}

