/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hc.core5.util.Args;

abstract class FrameOutputStream
extends OutputStream {
    private final OutputStream outputStream;
    private final byte[] cache;
    private int cachePosition;

    public FrameOutputStream(int n2, OutputStream outputStream) {
        this.outputStream = Args.notNull(outputStream, "Output stream");
        this.cache = new byte[n2];
    }

    protected abstract void write(ByteBuffer var1, boolean var2, OutputStream var3) throws IOException;

    private void flushCache(boolean bl2) throws IOException {
        if (this.cachePosition > 0) {
            FrameOutputStream frameOutputStream = this;
            frameOutputStream.write(ByteBuffer.wrap(frameOutputStream.cache, 0, this.cachePosition), bl2, this.outputStream);
            this.cachePosition = 0;
        }
    }

    @Override
    public void write(int n2) throws IOException {
        this.cache[this.cachePosition] = (byte)n2;
        ++this.cachePosition;
        if (this.cachePosition == this.cache.length) {
            this.flushCache(false);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 >= this.cache.length - this.cachePosition) {
            this.flushCache(false);
            this.write(ByteBuffer.wrap(byArray, n2, n3), false, this.outputStream);
            return;
        }
        System.arraycopy(byArray, n2, this.cache, this.cachePosition, n3);
        this.cachePosition += n3;
    }

    @Override
    public void flush() throws IOException {
        this.flushCache(false);
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.cachePosition > 0) {
            this.flushCache(true);
        } else {
            this.write(null, true, this.outputStream);
        }
        this.flushCache(true);
        this.outputStream.flush();
    }
}

